/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogExtractTagTransformer
implements Function<ReportLog, ReportLog> {
    protected final String tag;
    protected final String input;
    protected final String patternReplace;
    protected final Pattern compiledSearchPattern;
    @Nullable
    protected final Pattern compiledMatchPattern;
    @Nullable
    protected final String patternReplaceInput;
    protected final PreprocessorRuleMetrics ruleMetrics;
    protected final Predicate<ReportLog> v2Predicate;

    public ReportLogExtractTagTransformer(String tag, String input, String patternSearch, String patternReplace, @Nullable String replaceInput, @Nullable String patternMatch, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null");
        this.input = (String)Preconditions.checkNotNull((Object)input, (Object)"[input] can't be null");
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"[input] can't be blank");
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.patternReplaceInput = replaceInput;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    protected boolean extractTag(@Nonnull ReportLog reportLog, String extractFrom, List<Annotation> buffer) {
        if (extractFrom == null || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(extractFrom).matches()) {
            return false;
        }
        Matcher patternMatcher = this.compiledSearchPattern.matcher(extractFrom);
        if (!patternMatcher.find()) {
            return false;
        }
        String value = patternMatcher.replaceAll(Util.expandPlaceholders((String)this.patternReplace, (ReportLog)reportLog));
        if (!value.isEmpty()) {
            buffer.add(new Annotation(this.tag, value));
            this.ruleMetrics.incrementRuleAppliedCounter();
        }
        return true;
    }

    protected void internalApply(@Nonnull ReportLog reportLog) {
        ArrayList<Annotation> buffer = new ArrayList<Annotation>();
        switch (this.input) {
            case "message": {
                if (!this.extractTag(reportLog, reportLog.getMessage(), buffer) || this.patternReplaceInput == null) break;
                reportLog.setMessage(this.compiledSearchPattern.matcher(reportLog.getMessage()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (ReportLog)reportLog)));
                break;
            }
            case "sourceName": {
                if (!this.extractTag(reportLog, reportLog.getHost(), buffer) || this.patternReplaceInput == null) break;
                reportLog.setHost(this.compiledSearchPattern.matcher(reportLog.getHost()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (ReportLog)reportLog)));
                break;
            }
            default: {
                for (Annotation logTagKV : reportLog.getAnnotations()) {
                    if (!logTagKV.getKey().equals(this.input) || !this.extractTag(reportLog, logTagKV.getValue(), buffer) || this.patternReplaceInput == null) continue;
                    logTagKV.setValue(this.compiledSearchPattern.matcher(logTagKV.getValue()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (ReportLog)reportLog)));
                }
            }
        }
        reportLog.getAnnotations().addAll(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            this.internalApply(reportLog);
            ReportLog reportLog3 = reportLog;
            return reportLog3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

