/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogRenameTagTransformer
implements Function<ReportLog, ReportLog> {
    private final String tag;
    private final String newTag;
    @Nullable
    private final Pattern compiledPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportLog> v2Predicate;

    public ReportLogRenameTagTransformer(String tag, String newTag, @Nullable String patternMatch, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null");
        this.newTag = (String)Preconditions.checkNotNull((Object)newTag, (Object)"[newtag] can't be null");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        Preconditions.checkArgument((!newTag.isEmpty() ? 1 : 0) != 0, (Object)"[newtag] can't be blank");
        this.compiledPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            Stream<Annotation> stream = reportLog.getAnnotations().stream().filter(a -> a.getKey().equals(this.tag) && (this.compiledPattern == null || this.compiledPattern.matcher(a.getValue()).matches()));
            List<Annotation> annotations = stream.collect(Collectors.toList());
            annotations.forEach(a -> a.setKey(this.newTag));
            if (!annotations.isEmpty()) {
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            ReportLog reportLog3 = reportLog;
            return reportLog3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

