/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointAddPrefixTransformer
implements Function<ReportPoint, ReportPoint> {
    @Nullable
    private final String prefix;

    public ReportPointAddPrefixTransformer(@Nullable String prefix) {
        this.prefix = prefix;
    }

    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        boolean isDeltaTildaPrefixed;
        if (reportPoint == null) {
            return null;
        }
        String metric = reportPoint.getMetric();
        boolean isTildaPrefixed = metric.charAt(0) == '~';
        boolean isDeltaPrefixed = metric.charAt(0) == '\u2206' || metric.charAt(0) == '\u0394';
        boolean bl = isDeltaTildaPrefixed = isDeltaPrefixed && metric.charAt(1) == '~';
        if (!(this.prefix == null || this.prefix.isEmpty() || isTildaPrefixed || isDeltaTildaPrefixed || isDeltaPrefixed)) {
            reportPoint.setMetric(this.prefix + "." + metric);
        }
        return reportPoint;
    }
}

