/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanAddAnnotationTransformer
implements Function<Span, Span> {
    protected final String key;
    protected final String value;
    protected final PreprocessorRuleMetrics ruleMetrics;
    protected final Predicate<Span> v2Predicate;

    public SpanAddAnnotationTransformer(String key, String value, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"[key] can't be null");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"[value] can't be null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"[key] can't be blank");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"[value] can't be blank");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            span.getAnnotations().add(new Annotation(this.key, Util.expandPlaceholders((String)this.value, (Span)span)));
            this.ruleMetrics.incrementRuleAppliedCounter();
            Span span3 = span;
            return span3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

