/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.LengthLimitActionType;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.preprocessor.PreprocessorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanLimitLengthTransformer
implements Function<Span, Span> {
    private final String scope;
    private final int maxLength;
    private final LengthLimitActionType actionSubtype;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final boolean firstMatchOnly;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    public SpanLimitLengthTransformer(@Nonnull String scope, int maxLength, @Nonnull LengthLimitActionType actionSubtype, @Nullable String patternMatch, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, @Nonnull PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        if (actionSubtype == LengthLimitActionType.DROP && (scope.equals("spanName") || scope.equals("sourceName"))) {
            throw new IllegalArgumentException("'drop' action type can't be used with spanName and sourceName scope!");
        }
        if (actionSubtype == LengthLimitActionType.TRUNCATE_WITH_ELLIPSIS && maxLength < 3) {
            throw new IllegalArgumentException("'maxLength' must be at least 3 for 'truncateWithEllipsis' action type!");
        }
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"[maxLength] needs to be > 0!");
        this.maxLength = maxLength;
        this.actionSubtype = actionSubtype;
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.firstMatchOnly = firstMatchOnly;
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            switch (this.scope) {
                case "spanName": {
                    if (span.getName().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getName()).matches()) break;
                    span.setName(PreprocessorUtil.truncate(span.getName(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (span.getName().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getSource()).matches()) break;
                    span.setSource(PreprocessorUtil.truncate(span.getSource(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    ArrayList annotations = new ArrayList(span.getAnnotations());
                    Iterator iterator = annotations.iterator();
                    boolean changed = false;
                    while (iterator.hasNext()) {
                        Annotation entry = (Annotation)iterator.next();
                        if (!entry.getKey().equals(this.scope) || entry.getValue().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(entry.getValue()).matches()) continue;
                        changed = true;
                        if (this.actionSubtype == LengthLimitActionType.DROP) {
                            iterator.remove();
                        } else {
                            entry.setValue(PreprocessorUtil.truncate(entry.getValue(), this.maxLength, this.actionSubtype));
                        }
                        this.ruleMetrics.incrementRuleAppliedCounter();
                        if (!this.firstMatchOnly) continue;
                        break;
                    }
                    if (!changed) break;
                    span.setAnnotations(annotations);
                }
            }
            String string = span;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

