/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanReplaceRegexTransformer
implements Function<Span, Span> {
    private final String patternReplace;
    private final String scope;
    private final Pattern compiledSearchPattern;
    private final Integer maxIterations;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final boolean firstMatchOnly;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    public SpanReplaceRegexTransformer(String scope, String patternSearch, String patternReplace, @Nullable String patternMatch, @Nullable Integer maxIterations, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.maxIterations = maxIterations != null ? maxIterations : 1;
        Preconditions.checkArgument((this.maxIterations > 0 ? 1 : 0) != 0, (Object)"[iterations] must be > 0");
        this.firstMatchOnly = firstMatchOnly;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    private String replaceString(@Nonnull Span span, String content) {
        Matcher patternMatcher = this.compiledSearchPattern.matcher(content);
        if (!patternMatcher.find()) {
            return content;
        }
        this.ruleMetrics.incrementRuleAppliedCounter();
        String replacement = Util.expandPlaceholders((String)this.patternReplace, (Span)span);
        for (int currentIteration = 0; currentIteration < this.maxIterations && (patternMatcher = this.compiledSearchPattern.matcher(content = patternMatcher.replaceAll(replacement))).find(); ++currentIteration) {
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            block6 : switch (this.scope) {
                case "spanName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getName()).matches()) break;
                    span.setName(this.replaceString(span, span.getName()));
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getSource()).matches()) break;
                    span.setSource(this.replaceString(span, span.getSource()));
                    break;
                }
                default: {
                    for (Annotation x : span.getAnnotations()) {
                        String newValue;
                        if (!x.getKey().equals(this.scope) || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(x.getValue()).matches() || (newValue = this.replaceString(span, x.getValue())).equals(x.getValue())) continue;
                        x.setValue(newValue);
                        if (!this.firstMatchOnly) continue;
                        break block6;
                    }
                }
            }
            String string = span;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

