/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.squareup.tape2.ObjectQueue;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.common.Utils;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class InMemorySubmissionQueue<T extends DataSubmissionTask<T>>
implements TaskQueue<T> {
    private static final Logger log = Logger.getLogger(InMemorySubmissionQueue.class.getCanonicalName());
    private static final int MAX_BUFFER_SIZE = 50000;
    private final ObjectQueue<T> wrapped;
    private final AtomicLong currentWeight = new AtomicLong();
    private T head;

    public InMemorySubmissionQueue() {
        this.wrapped = ObjectQueue.createInMemory();
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    @Nullable
    public Long weight() {
        return this.currentWeight.get();
    }

    @Override
    @Nullable
    public Long getAvailableBytes() {
        return null;
    }

    @Override
    @Nullable
    public T peek() {
        try {
            if (this.head != null) {
                return this.head;
            }
            this.head = (DataSubmissionTask)this.wrapped.peek();
            return this.head;
        }
        catch (IOException ex) {
            throw (Error)Utils.throwAny(ex);
        }
    }

    @Override
    public void add(@Nonnull T entry) throws IOException {
        if (this.wrapped.size() >= 50000) {
            log.severe("Memory buffer full - too many outstanding tasks (50000)");
            return;
        }
        this.wrapped.add(entry);
        this.currentWeight.addAndGet(entry.weight());
    }

    @Override
    public void clear() throws IOException {
        this.wrapped.clear();
        this.head = null;
        this.currentWeight.set(0L);
    }

    @Override
    public void remove() throws IOException {
        T t = this.peek();
        long weight = t == null ? 0L : (long)t.weight();
        this.currentWeight.getAndUpdate(x -> x > weight ? x - weight : 0L);
        this.wrapped.remove();
        this.head = null;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }
}

