/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.sampler;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.wavefront.api.agent.SpanSamplingPolicy;
import com.wavefront.predicates.ExpressionSyntaxException;
import com.wavefront.predicates.Predicates;
import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import com.yammer.metrics.core.Counter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanSampler {
    public static final String SPAN_SAMPLING_POLICY_TAG = "_sampledByPolicy";
    private static final int EXPIRE_AFTER_ACCESS_SECONDS = 3600;
    private static final int POLICY_BASED_SAMPLING_MOD_FACTOR = 100;
    private static final Logger logger = Logger.getLogger(SpanSampler.class.getCanonicalName());
    private final Sampler delegate;
    private final LoadingCache<String, Predicate<Span>> spanPredicateCache = Caffeine.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Predicate<Span>>(){

        @Nullable
        public Predicate<Span> load(@NonNull String key) {
            try {
                return Predicates.fromPredicateEvalExpression((String)key);
            }
            catch (ExpressionSyntaxException ex) {
                logger.severe("Policy expression " + key + " is invalid: " + ex.getMessage());
                return null;
            }
        }
    });
    private final Supplier<List<SpanSamplingPolicy>> activeSpanSamplingPoliciesSupplier;

    public SpanSampler(Sampler delegate, @Nonnull Supplier<List<SpanSamplingPolicy>> activeSpanSamplingPoliciesSupplier) {
        this.delegate = delegate;
        this.activeSpanSamplingPoliciesSupplier = activeSpanSamplingPoliciesSupplier;
    }

    public boolean sample(Span span) {
        return this.sample(span, null);
    }

    public boolean sample(Span span, @Nullable Counter discarded) {
        if (this.isForceSampled(span)) {
            return true;
        }
        List<SpanSamplingPolicy> activeSpanSamplingPolicies = this.activeSpanSamplingPoliciesSupplier.get();
        if (activeSpanSamplingPolicies != null) {
            int samplingPercent = 0;
            String policyId = null;
            for (SpanSamplingPolicy policy : activeSpanSamplingPolicies) {
                Predicate spanPredicate = (Predicate)this.spanPredicateCache.get((Object)policy.getExpression());
                if (spanPredicate == null || !spanPredicate.test(span) || policy.getSamplingPercent() <= samplingPercent) continue;
                samplingPercent = policy.getSamplingPercent();
                policyId = policy.getPolicyId();
            }
            if (samplingPercent > 0 && Math.abs(UUID.fromString(span.getTraceId()).getLeastSignificantBits()) % 100L <= (long)samplingPercent) {
                if (span.getAnnotations() == null) {
                    span.setAnnotations(new ArrayList());
                }
                span.getAnnotations().add(new Annotation(SPAN_SAMPLING_POLICY_TAG, policyId));
                return true;
            }
        }
        if (this.delegate.sample(span.getName(), UUID.fromString(span.getTraceId()).getLeastSignificantBits(), span.getDuration())) {
            return true;
        }
        if (discarded != null) {
            discarded.inc();
        }
        return false;
    }

    private boolean isForceSampled(Span span) {
        List annotations = span.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!"debug".equals(annotation.getKey()) || !annotation.getValue().equals("true")) continue;
            return true;
        }
        return false;
    }
}

