/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class SSLConnectionSocketFactoryImpl
implements LayeredConnectionSocketFactory {
    private final SSLConnectionSocketFactory delegate;
    private final int soTimeout;

    public SSLConnectionSocketFactoryImpl(SSLConnectionSocketFactory delegate, int soTimeoutMs) {
        this.delegate = delegate;
        this.soTimeout = soTimeoutMs;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        Socket socket1 = this.delegate.createSocket(context);
        socket1.setSoTimeout(this.soTimeout);
        return socket1;
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket socket1 = this.delegate.connectSocket(this.soTimeout, sock, host, remoteAddress, localAddress, context);
        socket1.setSoTimeout(this.soTimeout);
        return socket1;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        Socket socket1 = this.delegate.createLayeredSocket(socket, target, port, context);
        socket1.setSoTimeout(this.soTimeout);
        return socket1;
    }
}

