/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.wavefront.agent.TenantInfo;
import com.wavefront.agent.TokenExchangeResponseDTO;
import com.wavefront.agent.TokenWorker;
import com.wavefront.agent.api.APIContainer;
import com.wavefront.agent.api.CSPAPI;
import com.wavefront.common.LazySupplier;
import com.wavefront.common.NamedThreadFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.Base64;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class TokenWorkerCSP
implements TokenWorker,
TokenWorker.External,
TokenWorker.Scheduled,
TenantInfo {
    private static final String GET_CSP_ACCESS_TOKEN_ERROR_MESSAGE = "Failed to get access token from CSP (%s). %s";
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("csp-token-updater"));
    private static final Logger log = Logger.getLogger(TokenWorkerCSP.class.getCanonicalName());
    private static final Supplier<Counter> errors = LazySupplier.of(() -> Metrics.newCounter((MetricName)new MetricName("csp.token.update", "", "exceptions")));
    private static final Supplier<Counter> executions = LazySupplier.of(() -> Metrics.newCounter((MetricName)new MetricName("csp.token.update", "", "executions")));
    private static final Supplier<Counter> successfully = LazySupplier.of(() -> Metrics.newCounter((MetricName)new MetricName("csp.token.update", "", "successfully")));
    private static final Supplier<Timer> duration = LazySupplier.of(() -> Metrics.newTimer((MetricName)new MetricName("csp.token.update", "", "duration"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES));
    private final String wfServer;
    private final ProxyAuthMethod proxyAuthMethod;
    private String appId;
    private String appSecret;
    private String orgId;
    private String token;
    private String bearerToken;
    private CSPAPI api;

    public TokenWorkerCSP(String appId, String appSecret, String orgId, String wfServer) {
        this.appId = (String)Preconditions.checkNotNull((Object)appId);
        this.appSecret = (String)Preconditions.checkNotNull((Object)appSecret);
        this.orgId = orgId;
        this.wfServer = (String)Preconditions.checkNotNull((Object)wfServer);
        this.proxyAuthMethod = ProxyAuthMethod.CLIENT_CREDENTIALS;
    }

    public TokenWorkerCSP(String token, String wfServer) {
        this.token = (String)Preconditions.checkNotNull((Object)token);
        this.wfServer = (String)Preconditions.checkNotNull((Object)wfServer);
        this.proxyAuthMethod = ProxyAuthMethod.API_TOKEN;
    }

    @Override
    public void setAPIContainer(APIContainer apiContainer) {
        this.api = apiContainer.getCSPApi();
    }

    @Override
    @Nonnull
    public String getWFServer() {
        return this.wfServer;
    }

    @Override
    public String getBearerToken() {
        return this.bearerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        executions.get().inc();
        TimerContext timer = duration.get().time();
        log.info("Updating CSP access token (" + (Object)((Object)this.proxyAuthMethod) + ").");
        long next = 10L;
        try {
            switch (this.proxyAuthMethod) {
                case CLIENT_CREDENTIALS: {
                    next = this.processResponse(this.loadAccessTokenByClientCredentials());
                    return;
                }
                case API_TOKEN: {
                    next = this.processResponse(this.loadAccessTokenByAPIToken());
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            errors.get().inc();
            log.log(Level.SEVERE, "Failed to get access token from CSP (%s). %s(" + (Object)((Object)this.proxyAuthMethod) + ")", e);
            return;
        }
        finally {
            timer.stop();
            executor.schedule(this::run, next, TimeUnit.SECONDS);
        }
    }

    public Response loadAccessTokenByAPIToken() {
        return this.api.getTokenByAPIToken("api_token", this.token);
    }

    public Response loadAccessTokenByClientCredentials() {
        String auth = String.format("Basic %s", Base64.getEncoder().encodeToString(String.format("%s:%s", this.appId, this.appSecret).getBytes()));
        if (Strings.isNullOrEmpty((String)this.orgId)) {
            return this.api.getTokenByClientCredentials(auth, "client_credentials");
        }
        return this.api.getTokenByClientCredentialsWithOrgId(auth, "client_credentials", this.orgId);
    }

    private long processResponse(Response response) {
        Metrics.newCounter((MetricName)new MetricName("csp.token.update.response", "", "" + response.getStatusInfo().getStatusCode())).inc();
        long nextIn = 10L;
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            errors.get().inc();
            String jsonString = (String)response.readEntity(String.class);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JsonNode jsonNode = objectMapper.readTree(jsonString);
                String message = jsonNode.get("message").asText();
                log.severe(String.format(GET_CSP_ACCESS_TOKEN_ERROR_MESSAGE, new Object[]{this.proxyAuthMethod, message}) + ". Status: " + response.getStatusInfo().getStatusCode());
            }
            catch (Exception e) {
                log.severe(String.format(GET_CSP_ACCESS_TOKEN_ERROR_MESSAGE, new Object[]{this.proxyAuthMethod, jsonString}) + ". Status: " + response.getStatusInfo().getStatusCode());
            }
        } else {
            try {
                TokenExchangeResponseDTO tokenExchangeResponseDTO = (TokenExchangeResponseDTO)response.readEntity(TokenExchangeResponseDTO.class);
                this.bearerToken = tokenExchangeResponseDTO.getAccessToken();
                nextIn = this.getTimeOffset(tokenExchangeResponseDTO.getExpiresIn());
                successfully.get().inc();
            }
            catch (Throwable e) {
                errors.get().inc();
                log.log(Level.SEVERE, "Failed to get access token from CSP (%s). %s(" + (Object)((Object)this.proxyAuthMethod) + ")", e);
            }
        }
        return nextIn;
    }

    private int getTimeOffset(int expiresIn) {
        if (expiresIn < 600) {
            return expiresIn - 30;
        }
        return expiresIn - 180;
    }

    private static enum ProxyAuthMethod {
        API_TOKEN,
        CLIENT_CREDENTIALS;

    }
}

