/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.formatter;

import javax.annotation.Nullable;

public enum DataFormat {
    DEFAULT,
    WAVEFRONT,
    HISTOGRAM,
    SOURCE_TAG,
    EVENT,
    SPAN,
    SPAN_LOG,
    LOGS_JSON_ARR,
    LOGS_JSON_LINES,
    LOGS_JSON_CLOUDWATCH;


    public static DataFormat autodetect(String input) {
        if (input.length() < 2) {
            return DEFAULT;
        }
        char firstChar = input.charAt(0);
        switch (firstChar) {
            case '@': {
                if (input.startsWith("@SourceTag") || input.startsWith("@SourceDescription")) {
                    return SOURCE_TAG;
                }
                if (!input.startsWith("@Event")) break;
                return EVENT;
            }
            case '{': {
                if (input.charAt(input.length() - 1) != '}') break;
                return SPAN_LOG;
            }
            case '!': {
                if (!input.startsWith("!M ") && !input.startsWith("!H ") && !input.startsWith("!D ")) break;
                return HISTOGRAM;
            }
            case '[': {
                if (input.charAt(input.length() - 1) != ']') break;
                return LOGS_JSON_ARR;
            }
        }
        return DEFAULT;
    }

    @Nullable
    public static DataFormat parse(String format) {
        if (format == null) {
            return null;
        }
        switch (format) {
            case "wavefront": 
            case "graphite_v2": {
                return WAVEFRONT;
            }
            case "histogram": {
                return HISTOGRAM;
            }
            case "trace": {
                return SPAN;
            }
            case "spanLogs": {
                return SPAN_LOG;
            }
            case "logs_json_arr": {
                return LOGS_JSON_ARR;
            }
            case "logs_json_lines": {
                return LOGS_JSON_LINES;
            }
            case "logs_json_cloudwatch": {
                return LOGS_JSON_CLOUDWATCH;
            }
        }
        return null;
    }
}

