/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.data.Validation;
import com.wavefront.dto.Event;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportEvent;

public class EventHandlerImpl
extends AbstractReportableEntityHandler<ReportEvent, Event> {
    private static final Logger logger = Logger.getLogger(AbstractReportableEntityHandler.class.getCanonicalName());
    private static final Function<ReportEvent, String> EVENT_SERIALIZER = value -> new Event(value).toString();
    private final Logger validItemsLogger;

    public EventHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, @Nullable Map<String, Collection<SenderTask<Event>>> senderTaskMap, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedEventsLogger, @Nullable Logger validEventsLogger) {
        super(handlerKey, blockedItemsPerBatch, EVENT_SERIALIZER, senderTaskMap, true, receivedRateSink, blockedEventsLogger);
        super.initializeCounters();
        this.validItemsLogger = validEventsLogger;
    }

    @Override
    protected void reportInternal(ReportEvent event) {
        if (!EventHandlerImpl.annotationKeysAreValid(event)) {
            throw new IllegalArgumentException("WF-401: Event annotation key has illegal characters.");
        }
        Event eventToAdd = new Event(event);
        this.getTask("central").add(eventToAdd);
        this.getReceivedCounter().inc();
        if (this.isMulticastingActive && event.getAnnotations() != null && event.getAnnotations().containsKey("multicastingTenantName")) {
            String[] multicastingTenantNames = ((String)event.getAnnotations().get("multicastingTenantName")).trim().split(",");
            event.getAnnotations().remove("multicastingTenantName");
            for (String multicastingTenantName : multicastingTenantNames) {
                if (this.getTask(multicastingTenantName) == null) continue;
                this.getTask(multicastingTenantName).add(new Event(event));
            }
        }
        if (this.validItemsLogger != null && this.validItemsLogger.isLoggable(Level.FINEST)) {
            this.validItemsLogger.info(EVENT_SERIALIZER.apply(event));
        }
    }

    @VisibleForTesting
    static boolean annotationKeysAreValid(ReportEvent event) {
        if (event.getAnnotations() != null) {
            for (String key : event.getAnnotations().keySet()) {
                if (Validation.charactersAreValid((String)key)) continue;
                return false;
            }
        }
        return true;
    }
}

