/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.EventDataSubmissionTask;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.handlers.AbstractSenderTask;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.EventAPI;
import com.wavefront.dto.Event;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

class EventSenderTask
extends AbstractSenderTask<Event> {
    private final EventAPI proxyAPI;
    private final UUID proxyId;
    private final TaskQueue<EventDataSubmissionTask> backlog;

    EventSenderTask(HandlerKey handlerKey, EventAPI proxyAPI, UUID proxyId, int threadId, EntityProperties properties, ScheduledExecutorService scheduler, TaskQueue<EventDataSubmissionTask> backlog) {
        super(handlerKey, threadId, properties, scheduler);
        this.proxyAPI = proxyAPI;
        this.proxyId = proxyId;
        this.backlog = backlog;
    }

    @Override
    TaskResult processSingleBatch(List<Event> batch) {
        EventDataSubmissionTask task = new EventDataSubmissionTask(this.proxyAPI, this.proxyId, this.properties, this.backlog, this.handlerKey.getHandle(), batch, null);
        return task.execute();
    }

    @Override
    public void flushSingleBatch(List<Event> batch, @Nullable QueueingReason reason) {
        EventDataSubmissionTask task = new EventDataSubmissionTask(this.proxyAPI, this.proxyId, this.properties, this.backlog, this.handlerKey.getHandle(), batch, null);
        task.enqueue(reason);
    }
}

