/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportPointHandlerImpl;
import com.wavefront.agent.histogram.Granularity;
import com.wavefront.agent.histogram.HistogramKey;
import com.wavefront.agent.histogram.HistogramUtils;
import com.wavefront.agent.histogram.accumulator.Accumulator;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Utils;
import com.wavefront.data.Validation;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

public class HistogramAccumulationHandlerImpl
extends ReportPointHandlerImpl {
    private final Accumulator digests;
    private final Granularity granularity;
    private final Supplier<Counter> pointCounter;
    private final Supplier<Counter> pointRejectedCounter;
    private final Supplier<Counter> histogramCounter;
    private final Supplier<Counter> histogramRejectedCounter;
    private final Supplier<com.yammer.metrics.core.Histogram> histogramBinCount;
    private final Supplier<com.yammer.metrics.core.Histogram> histogramSampleCount;

    public HistogramAccumulationHandlerImpl(HandlerKey handlerKey, Accumulator digests, int blockedItemsPerBatch, @Nullable Granularity granularity, @Nonnull ValidationConfiguration validationConfig, boolean isHistogramInput, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedItemLogger, @Nullable Logger validItemsLogger) {
        super(handlerKey, blockedItemsPerBatch, null, validationConfig, !isHistogramInput, receivedRateSink, blockedItemLogger, validItemsLogger, null);
        super.initializeCounters();
        this.digests = digests;
        this.granularity = granularity;
        String metricNamespace = "histogram.accumulator." + HistogramUtils.granularityToString(granularity);
        this.pointCounter = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName(metricNamespace, "", "sample_added")));
        this.pointRejectedCounter = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName(metricNamespace, "", "sample_rejected")));
        this.histogramCounter = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName(metricNamespace, "", "histogram_added")));
        this.histogramRejectedCounter = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName(metricNamespace, "", "histogram_rejected")));
        this.histogramBinCount = Utils.lazySupplier(() -> Metrics.newHistogram((MetricName)new MetricName(metricNamespace, "", "histogram_bins")));
        this.histogramSampleCount = Utils.lazySupplier(() -> Metrics.newHistogram((MetricName)new MetricName(metricNamespace, "", "histogram_samples")));
    }

    @Override
    protected void reportInternal(ReportPoint point) {
        Validation.validatePoint((ReportPoint)point, (ValidationConfiguration)this.validationConfig);
        if (point.getValue() instanceof Double) {
            if (this.granularity == null) {
                this.pointRejectedCounter.get().inc();
                this.reject(point, "Wavefront data format is not supported on distribution ports!");
                return;
            }
            HistogramKey histogramKey = HistogramUtils.makeKey(point, this.granularity);
            double value = (Double)point.getValue();
            this.pointCounter.get().inc();
            this.digests.put(histogramKey, value);
        } else if (point.getValue() instanceof Histogram) {
            Histogram value = (Histogram)point.getValue();
            Granularity pointGranularity = Granularity.fromMillis(value.getDuration());
            if (this.granularity != null && pointGranularity.getInMillis() > this.granularity.getInMillis()) {
                this.reject(point, "Attempting to send coarser granularity (" + HistogramUtils.granularityToString(pointGranularity) + ") distribution to a finer granularity (" + HistogramUtils.granularityToString(this.granularity) + ") port");
                this.histogramRejectedCounter.get().inc();
                return;
            }
            this.histogramBinCount.get().update(value.getCounts().size());
            this.histogramSampleCount.get().update(value.getCounts().stream().mapToLong(x -> x.intValue()).sum());
            HistogramKey histogramKey = HistogramUtils.makeKey(point, this.granularity == null ? pointGranularity : this.granularity);
            this.histogramCounter.get().inc();
            this.digests.put(histogramKey, value);
        }
        if (this.validItemsLogger != null && this.validItemsLogger.isLoggable(Level.FINEST)) {
            this.validItemsLogger.info((String)this.serializer.apply(point));
        }
    }
}

