/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.common.Clock;
import com.wavefront.common.Utils;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportPoint;

public class InternalProxyWavefrontClient
implements WavefrontSender {
    private final Supplier<ReportableEntityHandler<ReportPoint, String>> pointHandlerSupplier = Utils.lazySupplier(() -> handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle)));
    private final Supplier<ReportableEntityHandler<ReportPoint, String>> histogramHandlerSupplier = Utils.lazySupplier(() -> handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.HISTOGRAM, handle)));
    private final String clientId;

    public InternalProxyWavefrontClient(ReportableEntityHandlerFactory handlerFactory, String handle) {
        this.clientId = handle;
    }

    public void flush() {
    }

    public int getFailureCount() {
        return 0;
    }

    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, Long timestamp, String source, Map<String, String> tags) {
        List bins = centroids.stream().map(x -> (Double)x._1).collect(Collectors.toList());
        List counts = centroids.stream().map(x -> (Integer)x._2).collect(Collectors.toList());
        for (HistogramGranularity granularity : histogramGranularities) {
            int duration;
            switch (granularity) {
                case MINUTE: {
                    duration = 60000;
                    break;
                }
                case HOUR: {
                    duration = 3600000;
                    break;
                }
                case DAY: {
                    duration = 86400000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown granularity: " + granularity);
                }
            }
            Histogram histogram = Histogram.newBuilder().setType(HistogramType.TDIGEST).setBins(bins).setCounts(counts).setDuration(duration).build();
            ReportPoint point = ReportPoint.newBuilder().setTable("unknown").setMetric(name).setValue(histogram).setTimestamp(timestamp.longValue()).setHost(source).setAnnotations(tags).build();
            this.histogramHandlerSupplier.get().report(point);
        }
    }

    public void sendMetric(String name, double value, Long timestamp, String source, Map<String, String> tags) {
        long timestampMillis = 0L;
        if ((timestamp = Long.valueOf(timestamp == null ? Clock.now() : timestamp)) < 10000000000L) {
            timestampMillis = timestamp * 1000L;
        } else if (timestamp < 10000000000000L) {
            timestampMillis = timestamp;
        } else if (timestamp < 10000000000000000L) {
            timestampMillis = timestamp / 1000L;
        } else if (timestamp <= 999999999999999999L) {
            timestampMillis = timestamp / 1000000L;
        }
        ReportPoint point = ReportPoint.newBuilder().setTable("unknown").setMetric(name).setValue(value).setTimestamp(timestampMillis).setHost(source).setAnnotations(tags).build();
        this.pointHandlerSupplier.get().report(point);
    }

    public void sendFormattedMetric(String s) {
        throw new UnsupportedOperationException("Not applicable");
    }

    public void sendSpan(String name, long startMillis, long durationMillis, String source, UUID traceId, UUID spanId, List<UUID> parents, List<UUID> followsFrom, List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) {
        throw new UnsupportedOperationException("Not applicable");
    }

    public void close() {
    }

    public String getClientId() {
        return this.clientId;
    }

    public void sendEvent(String name, long startMillis, long endMillis, String source, Map<String, String> tags, Map<String, String> annotations) throws IOException {
        throw new UnsupportedOperationException("Not applicable");
    }

    public void sendLog(String name, double value, Long timestamp, String source, Map<String, String> tags) throws IOException {
        throw new UnsupportedOperationException("Not applicable");
    }
}

