/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.data.SourceTagSubmissionTask;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.handlers.AbstractSenderTask;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.SourceTagAPI;
import com.wavefront.dto.SourceTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class SourceTagSenderTask
extends AbstractSenderTask<SourceTag> {
    private static final Logger logger = Logger.getLogger(SourceTagSenderTask.class.getCanonicalName());
    private final SourceTagAPI proxyAPI;
    private final TaskQueue<SourceTagSubmissionTask> backlog;

    SourceTagSenderTask(HandlerKey handlerKey, SourceTagAPI proxyAPI, int threadId, EntityProperties properties, ScheduledExecutorService scheduler, TaskQueue<SourceTagSubmissionTask> backlog) {
        super(handlerKey, threadId, properties, scheduler);
        this.proxyAPI = proxyAPI;
        this.backlog = backlog;
    }

    @Override
    TaskResult processSingleBatch(List<SourceTag> batch) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long nextRunMillis = this.properties.getPushFlushInterval();
        this.isSending = true;
        try {
            List current = this.createBatch();
            if (current.size() == 0) {
                return;
            }
            Iterator iterator = current.iterator();
            block12: while (iterator.hasNext()) {
                if (this.rateLimiter == null || this.rateLimiter.tryAcquire()) {
                    SourceTag tag = (SourceTag)iterator.next();
                    SourceTagSubmissionTask task = new SourceTagSubmissionTask(this.proxyAPI, this.properties, this.backlog, this.handlerKey.getHandle(), tag, null);
                    TaskResult result = task.execute();
                    this.attemptedCounter.inc();
                    switch (result) {
                        case DELIVERED: {
                            continue block12;
                        }
                        case PERSISTED: 
                        case PERSISTED_RETRY: {
                            if (this.rateLimiter == null) continue block12;
                            this.rateLimiter.recyclePermits(1);
                            continue block12;
                        }
                        case RETRY_LATER: {
                            ArrayList<SourceTag> remainingItems = new ArrayList<SourceTag>();
                            remainingItems.add(tag);
                            iterator.forEachRemaining(remainingItems::add);
                            this.undoBatch(remainingItems);
                            if (this.rateLimiter != null) {
                                this.rateLimiter.recyclePermits(1);
                            }
                            return;
                        }
                    }
                    continue;
                }
                ArrayList remainingItems = new ArrayList();
                iterator.forEachRemaining(remainingItems::add);
                this.undoBatch(remainingItems);
                long willRetryIn = nextRunMillis = (long)((int)(1.0 + Math.random())) * nextRunMillis / 4L;
                this.throttledLogger.log(Level.INFO, () -> "[" + this.handlerKey.getHandle() + " thread " + this.threadId + "]: WF-4 Proxy rate limiter active (pending " + this.handlerKey.getEntityType() + ": " + this.datum.size() + "), will retry in " + willRetryIn + "ms");
                return;
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unexpected error in flush loop", t);
        }
        finally {
            this.isSending = false;
            this.scheduler.schedule(this, nextRunMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    void flushSingleBatch(List<SourceTag> batch, @Nullable QueueingReason reason) {
        for (SourceTag tag : batch) {
            SourceTagSubmissionTask task = new SourceTagSubmissionTask(this.proxyAPI, this.properties, this.backlog, this.handlerKey.getHandle(), tag, null);
            task.enqueue(reason);
        }
    }
}

