/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

public enum Granularity {
    MINUTE(60000),
    HOUR(3600000),
    DAY(86400000);

    private final int inMillis;

    private Granularity(int inMillis) {
        this.inMillis = inMillis;
    }

    public int getInMillis() {
        return this.inMillis;
    }

    public int getBinId(long timeMillis) {
        return (int)(timeMillis / (long)this.inMillis);
    }

    public String toString() {
        switch (this) {
            case DAY: {
                return "day";
            }
            case HOUR: {
                return "hour";
            }
            case MINUTE: {
                return "minute";
            }
        }
        return "unknown";
    }

    public static Granularity fromMillis(long millis) {
        if (millis <= 60000L) {
            return MINUTE;
        }
        if (millis <= 3600000L) {
            return HOUR;
        }
        return DAY;
    }
}

