/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.histogram.Granularity;
import com.wavefront.agent.histogram.HistogramKey;
import com.wavefront.agent.histogram.HistogramUtils;
import com.wavefront.agent.histogram.accumulator.Accumulator;
import com.wavefront.common.TimeProvider;
import com.wavefront.common.logger.MessageDedupingLogger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class PointHandlerDispatcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(PointHandlerDispatcher.class.getCanonicalName());
    private static final Logger featureDisabledLogger = new MessageDedupingLogger(logger, 2L, 0.2);
    private final Counter dispatchCounter;
    private final Counter dispatchErrorCounter;
    private final Counter dispatchProcessTime;
    private final Accumulator digests;
    private final AtomicLong digestsSize = new AtomicLong(0L);
    private final ReportableEntityHandler<ReportPoint, String> output;
    private final TimeProvider clock;
    private final Supplier<Boolean> histogramDisabled;
    private final Integer dispatchLimit;

    public PointHandlerDispatcher(Accumulator digests, ReportableEntityHandler<ReportPoint, String> output, TimeProvider clock, Supplier<Boolean> histogramDisabled, @Nullable Integer dispatchLimit, @Nullable Granularity granularity) {
        this.digests = digests;
        this.output = output;
        this.clock = clock;
        this.histogramDisabled = histogramDisabled;
        this.dispatchLimit = dispatchLimit;
        String prefix = "histogram.accumulator." + HistogramUtils.granularityToString(granularity);
        this.dispatchCounter = Metrics.newCounter((MetricName)new MetricName(prefix, "", "dispatched"));
        this.dispatchErrorCounter = Metrics.newCounter((MetricName)new MetricName(prefix, "", "dispatch_errors"));
        Metrics.newGauge((MetricName)new MetricName(prefix, "", "size"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return PointHandlerDispatcher.this.digestsSize.get();
            }
        });
        this.dispatchProcessTime = Metrics.newCounter((MetricName)new MetricName(prefix, "", "dispatch_process_millis"));
    }

    @Override
    public void run() {
        try {
            AtomicInteger dispatchedCount = new AtomicInteger(0);
            long startMillis = System.currentTimeMillis();
            this.digestsSize.set(this.digests.size());
            Iterator<HistogramKey> index = this.digests.getRipeDigestsIterator(this.clock);
            while (index.hasNext()) {
                this.digests.compute(index.next(), (k, v) -> {
                    if (v == null) {
                        index.remove();
                        return null;
                    }
                    if (this.histogramDisabled.get().booleanValue()) {
                        featureDisabledLogger.info("Histogram feature is not enabled on the server!");
                        this.dispatchErrorCounter.inc();
                    } else {
                        try {
                            ReportPoint out = HistogramUtils.pointFromKeyAndDigest(k, v);
                            this.output.report(out);
                            this.dispatchCounter.inc();
                        }
                        catch (Exception e) {
                            this.dispatchErrorCounter.inc();
                            logger.log(Level.SEVERE, "Failed dispatching entry " + k, e);
                        }
                    }
                    index.remove();
                    dispatchedCount.incrementAndGet();
                    return null;
                });
                if (this.dispatchLimit == null || dispatchedCount.get() < this.dispatchLimit) continue;
            }
            this.dispatchProcessTime.inc(System.currentTimeMillis() - startMillis);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PointHandlerDispatcher error", e);
        }
    }
}

