/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.listeners.AbstractLineDelimitedHandler;
import com.wavefront.agent.logsharvesting.LogsIngester;
import com.wavefront.agent.logsharvesting.LogsMessage;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.InetAddress;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RawLogsIngesterPortUnificationHandler
extends AbstractLineDelimitedHandler {
    private static final Logger logger = Logger.getLogger(RawLogsIngesterPortUnificationHandler.class.getCanonicalName());
    private final LogsIngester logsIngester;
    private final Function<InetAddress, String> hostnameResolver;
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final Counter received = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "raw-received"));

    public RawLogsIngesterPortUnificationHandler(String handle, @Nonnull LogsIngester ingester, @Nonnull Function<InetAddress, String> hostnameResolver, @Nullable TokenAuthenticator authenticator, @Nullable HealthCheckManager healthCheckManager, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        super(authenticator, healthCheckManager, handle);
        this.logsIngester = ingester;
        this.hostnameResolver = hostnameResolver;
        this.preprocessorSupplier = preprocessor;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof TooLongFrameException) {
            this.logWarning("Received line is too long, consider increasing rawLogsMaxReceivedLength", cause, ctx);
            return;
        }
        if (cause instanceof DecoderException) {
            logger.log(Level.WARNING, "Unexpected exception in raw logs ingester", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    @Override
    @Nullable
    protected DataFormat getFormat(FullHttpRequest httpRequest) {
        return null;
    }

    @Override
    @VisibleForTesting
    public void processLine(final ChannelHandlerContext ctx, @Nonnull String message, @Nullable DataFormat format) {
        String processedMessage;
        this.received.inc();
        ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier == null ? null : this.preprocessorSupplier.get();
        String string = processedMessage = preprocessor == null ? message : preprocessor.forPointLine().transform(message);
        if (preprocessor != null && !preprocessor.forPointLine().filter(message, null)) {
            return;
        }
        this.logsIngester.ingestLog(new LogsMessage(){

            @Override
            public String getLogLine() {
                return processedMessage;
            }

            @Override
            public String hostOrDefault(String fallbackHost) {
                String hostname = (String)RawLogsIngesterPortUnificationHandler.this.hostnameResolver.apply(ChannelUtils.getRemoteAddress(ctx));
                return StringUtils.isBlank((String)hostname) ? fallbackHost : hostname;
            }
        });
    }
}

