/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.otlp;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.yammer.metrics.core.Counter;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.ScopeSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;

public class OtlpTraceUtils {
    public static final String OTEL_DROPPED_ATTRS_KEY = "otel.dropped_attributes_count";
    public static final String OTEL_DROPPED_EVENTS_KEY = "otel.dropped_events_count";
    public static final String OTEL_DROPPED_LINKS_KEY = "otel.dropped_links_count";
    public static final String OTEL_SERVICE_NAME_KEY = "service.name";
    public static final String OTEL_STATUS_DESCRIPTION_KEY = "otel.status_description";
    private static final String DEFAULT_APPLICATION_NAME = "defaultApplication";
    private static final String DEFAULT_SERVICE_NAME = "defaultService";
    private static final Logger OTLP_DATA_LOGGER = Logger.getLogger("OTLPDataLogger");
    private static final String SPAN_EVENT_TAG_KEY = "name";
    private static final String SPAN_KIND_TAG_KEY = "span.kind";
    private static final HashMap<Span.SpanKind, Annotation> SPAN_KIND_ANNOTATION_HASH_MAP = new HashMap<Span.SpanKind, Annotation>(){
        {
            this.put(Span.SpanKind.SPAN_KIND_CLIENT, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "client"));
            this.put(Span.SpanKind.SPAN_KIND_CONSUMER, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "consumer"));
            this.put(Span.SpanKind.SPAN_KIND_INTERNAL, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "internal"));
            this.put(Span.SpanKind.SPAN_KIND_PRODUCER, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "producer"));
            this.put(Span.SpanKind.SPAN_KIND_SERVER, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "server"));
            this.put(Span.SpanKind.SPAN_KIND_UNSPECIFIED, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "unspecified"));
            this.put(Span.SpanKind.UNRECOGNIZED, new Annotation(OtlpTraceUtils.SPAN_KIND_TAG_KEY, "unknown"));
        }
    };

    public static KeyValue getAttrByKey(List<KeyValue> attributesList, String key) {
        return attributesList.stream().filter(kv -> key.equals(kv.getKey())).findFirst().orElse(null);
    }

    public static KeyValue buildKeyValue(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value).build()).build();
    }

    public static void exportToWavefront(ExportTraceServiceRequest request, ReportableEntityHandler<Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, Pair<Supplier<Boolean>, Counter> spanLogsDisabled, Pair<SpanSampler, Counter> samplerAndCounter, String defaultSource, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics, WavefrontInternalReporter internalReporter, Set<String> traceDerivedCustomTagKeys) {
        ReportableEntityPreprocessor preprocessor = null;
        if (preprocessorSupplier != null) {
            preprocessor = preprocessorSupplier.get();
        }
        for (WavefrontSpanAndLogs spanAndLogs : OtlpTraceUtils.fromOtlpRequest(request, preprocessor, defaultSource)) {
            Span span = spanAndLogs.getSpan();
            SpanLogs spanLogs = spanAndLogs.getSpanLogs();
            if (OtlpTraceUtils.wasFilteredByPreprocessor(span, spanHandler, preprocessor)) continue;
            if (((SpanSampler)samplerAndCounter._1).sample(span, (Counter)samplerAndCounter._2)) {
                spanHandler.report(span);
                if (OtlpTraceUtils.shouldReportSpanLogs(spanLogs.getLogs().size(), spanLogsDisabled)) {
                    SpanUtils.addSpanLine(span, spanLogs);
                    spanLogsHandler.report(spanLogs);
                }
            }
            discoveredHeartbeatMetrics.add(OtlpTraceUtils.reportREDMetrics(span, internalReporter, traceDerivedCustomTagKeys));
        }
    }

    @VisibleForTesting
    static List<WavefrontSpanAndLogs> fromOtlpRequest(ExportTraceServiceRequest request, @Nullable ReportableEntityPreprocessor preprocessor, String defaultSource) {
        ArrayList<WavefrontSpanAndLogs> wfSpansAndLogs = new ArrayList<WavefrontSpanAndLogs>();
        for (ResourceSpans rSpans : request.getResourceSpansList()) {
            Resource resource = rSpans.getResource();
            OTLP_DATA_LOGGER.finest(() -> "Inbound OTLP Resource: " + resource);
            for (ScopeSpans scopeSpans : rSpans.getScopeSpansList()) {
                InstrumentationScope scope = scopeSpans.getScope();
                OTLP_DATA_LOGGER.finest(() -> "Inbound OTLP Instrumentation Scope: " + scope);
                for (io.opentelemetry.proto.trace.v1.Span otlpSpan : scopeSpans.getSpansList()) {
                    OTLP_DATA_LOGGER.finest(() -> "Inbound OTLP Span: " + otlpSpan);
                    wfSpansAndLogs.add(OtlpTraceUtils.transformAll(otlpSpan, resource.getAttributesList(), scope, preprocessor, defaultSource));
                }
            }
        }
        return wfSpansAndLogs;
    }

    @VisibleForTesting
    static boolean wasFilteredByPreprocessor(Span wfSpan, ReportableEntityHandler<Span, String> spanHandler, @Nullable ReportableEntityPreprocessor preprocessor) {
        if (preprocessor == null) {
            return false;
        }
        String[] messageHolder = new String[1];
        if (!preprocessor.forSpan().filter(wfSpan, messageHolder)) {
            if (messageHolder[0] != null) {
                spanHandler.reject(wfSpan, messageHolder[0]);
            } else {
                spanHandler.block(wfSpan);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static WavefrontSpanAndLogs transformAll(io.opentelemetry.proto.trace.v1.Span otlpSpan, List<KeyValue> resourceAttributes, InstrumentationScope scope, @Nullable ReportableEntityPreprocessor preprocessor, String defaultSource) {
        Span span = OtlpTraceUtils.transformSpan(otlpSpan, resourceAttributes, scope, preprocessor, defaultSource);
        SpanLogs logs = OtlpTraceUtils.transformEvents(otlpSpan, span);
        if (!logs.getLogs().isEmpty()) {
            span.getAnnotations().add(new Annotation("_spanLogs", "true"));
        }
        OTLP_DATA_LOGGER.finest(() -> "Converted Wavefront Span: " + span);
        if (!logs.getLogs().isEmpty()) {
            OTLP_DATA_LOGGER.finest(() -> "Converted Wavefront SpanLogs: " + logs);
        }
        return new WavefrontSpanAndLogs(span, logs);
    }

    @VisibleForTesting
    static Span transformSpan(io.opentelemetry.proto.trace.v1.Span otlpSpan, List<KeyValue> resourceAttrs, InstrumentationScope scope, ReportableEntityPreprocessor preprocessor, String defaultSource) {
        Pair<String, List<KeyValue>> sourceAndResourceAttrs = OtlpTraceUtils.sourceFromAttributes(resourceAttrs, defaultSource);
        String source = (String)sourceAndResourceAttrs._1;
        resourceAttrs = (List)sourceAndResourceAttrs._2;
        List<KeyValue> otlpAttributes = Stream.of(resourceAttrs, otlpSpan.getAttributesList()).flatMap(Collection::stream).collect(Collectors.toList());
        List<Annotation> wfAnnotations = OtlpTraceUtils.annotationsFromAttributes(otlpAttributes);
        wfAnnotations.add(SPAN_KIND_ANNOTATION_HASH_MAP.get(otlpSpan.getKind()));
        wfAnnotations.addAll(OtlpTraceUtils.annotationsFromStatus(otlpSpan.getStatus()));
        wfAnnotations.addAll(OtlpTraceUtils.annotationsFromInstrumentationScope(scope));
        wfAnnotations.addAll(OtlpTraceUtils.annotationsFromDroppedCounts(otlpSpan));
        wfAnnotations.addAll(OtlpTraceUtils.annotationsFromTraceState(otlpSpan.getTraceState()));
        wfAnnotations.addAll(OtlpTraceUtils.annotationsFromParentSpanID(otlpSpan.getParentSpanId()));
        String wfSpanId = SpanUtils.toStringId(otlpSpan.getSpanId());
        String wfTraceId = SpanUtils.toStringId(otlpSpan.getTraceId());
        long startTimeMs = TimeUnit.NANOSECONDS.toMillis(otlpSpan.getStartTimeUnixNano());
        long durationMs = otlpSpan.getEndTimeUnixNano() == 0L ? 0L : TimeUnit.NANOSECONDS.toMillis(otlpSpan.getEndTimeUnixNano() - otlpSpan.getStartTimeUnixNano());
        Span toReturn = Span.newBuilder().setName(otlpSpan.getName()).setSpanId(wfSpanId).setTraceId(wfTraceId).setStartMillis(startTimeMs).setDuration(durationMs).setAnnotations(wfAnnotations).setSource(source).setCustomer("dummy").build();
        if (preprocessor != null) {
            preprocessor.forSpan().transform(toReturn);
        }
        List<Annotation> processedAnnotationList = OtlpTraceUtils.setRequiredTags(toReturn.getAnnotations());
        toReturn.setAnnotations(processedAnnotationList);
        return toReturn;
    }

    @VisibleForTesting
    static SpanLogs transformEvents(io.opentelemetry.proto.trace.v1.Span otlpSpan, Span wfSpan) {
        ArrayList<SpanLog> logs = new ArrayList<SpanLog>();
        for (Span.Event event : otlpSpan.getEventsList()) {
            SpanLog log = new SpanLog();
            log.setTimestamp(TimeUnit.NANOSECONDS.toMicros(event.getTimeUnixNano()));
            Map<String, String> fields = OtlpTraceUtils.mapFromAttributes(event.getAttributesList());
            fields.put(SPAN_EVENT_TAG_KEY, event.getName());
            if (event.getDroppedAttributesCount() != 0) {
                fields.put(OTEL_DROPPED_ATTRS_KEY, String.valueOf(event.getDroppedAttributesCount()));
            }
            log.setFields(fields);
            logs.add(log);
        }
        return SpanLogs.newBuilder().setLogs(logs).setSpanId(wfSpan.getSpanId()).setTraceId(wfSpan.getTraceId()).setCustomer(wfSpan.getCustomer()).build();
    }

    @VisibleForTesting
    static Pair<String, List<KeyValue>> sourceFromAttributes(List<KeyValue> otlpAttributes, String defaultSource) {
        List<String> candidateKeys = Arrays.asList("source", "host.name", "hostname", "host.id");
        Comparator<KeyValue> keySorter = Comparator.comparing(kv -> candidateKeys.indexOf(kv.getKey()));
        Optional<KeyValue> sourceAttr = otlpAttributes.stream().filter(kv -> candidateKeys.contains(kv.getKey())).sorted(keySorter).findFirst();
        if (sourceAttr.isPresent()) {
            ArrayList<KeyValue> attributesWithoutSource = new ArrayList<KeyValue>(otlpAttributes);
            attributesWithoutSource.remove(sourceAttr.get());
            return new Pair((Object)OtlpTraceUtils.fromAnyValue(sourceAttr.get().getValue()), attributesWithoutSource);
        }
        return new Pair((Object)defaultSource, otlpAttributes);
    }

    @VisibleForTesting
    static List<Annotation> annotationsFromAttributes(List<KeyValue> attributesList) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (KeyValue attribute : attributesList) {
            String key = attribute.getKey().equals("source") ? "_source" : attribute.getKey();
            Annotation.Builder annotationBuilder = Annotation.newBuilder().setKey(key);
            if (!attribute.hasValue()) {
                annotationBuilder.setValue("");
            } else {
                annotationBuilder.setValue(OtlpTraceUtils.fromAnyValue(attribute.getValue()));
            }
            annotations.add(annotationBuilder.build());
        }
        return annotations;
    }

    @VisibleForTesting
    static List<Annotation> annotationsFromInstrumentationScope(InstrumentationScope scope) {
        if (scope == null || scope.getName().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        annotations.add(new Annotation("otel.scope.name", scope.getName()));
        if (!scope.getVersion().isEmpty()) {
            annotations.add(new Annotation("otel.scope.version", scope.getVersion()));
        }
        return annotations;
    }

    @VisibleForTesting
    static List<Annotation> annotationsFromDroppedCounts(io.opentelemetry.proto.trace.v1.Span otlpSpan) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (otlpSpan.getDroppedAttributesCount() != 0) {
            annotations.add(new Annotation(OTEL_DROPPED_ATTRS_KEY, String.valueOf(otlpSpan.getDroppedAttributesCount())));
        }
        if (otlpSpan.getDroppedEventsCount() != 0) {
            annotations.add(new Annotation(OTEL_DROPPED_EVENTS_KEY, String.valueOf(otlpSpan.getDroppedEventsCount())));
        }
        if (otlpSpan.getDroppedLinksCount() != 0) {
            annotations.add(new Annotation(OTEL_DROPPED_LINKS_KEY, String.valueOf(otlpSpan.getDroppedLinksCount())));
        }
        return annotations;
    }

    @VisibleForTesting
    static Pair<Map<String, String>, String> reportREDMetrics(Span span, WavefrontInternalReporter internalReporter, Set<String> traceDerivedCustomTagKeys) {
        Map<String, String> annotations = OtlpTraceUtils.mapFromAnnotations(span.getAnnotations());
        List spanTags = span.getAnnotations().stream().map(a -> Pair.of((Object)a.getKey(), (Object)a.getValue())).collect(Collectors.toList());
        return SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)internalReporter, (String)span.getName(), (String)annotations.get("application"), (String)annotations.get("service"), (String)annotations.get("cluster"), (String)annotations.get("shard"), (String)span.getSource(), (String)annotations.getOrDefault("component", "none"), (boolean)Boolean.parseBoolean(annotations.get("error")), (long)TimeUnit.MILLISECONDS.toMicros(span.getDuration()), traceDerivedCustomTagKeys, spanTags);
    }

    @VisibleForTesting
    static List<Annotation> setRequiredTags(List<Annotation> annotationList) {
        Map<String, String> tags = OtlpTraceUtils.mapFromAnnotations(annotationList);
        ArrayList<Annotation> requiredTags = new ArrayList<Annotation>();
        if (!tags.containsKey("service")) {
            tags.put("service", tags.getOrDefault(OTEL_SERVICE_NAME_KEY, DEFAULT_SERVICE_NAME));
        }
        tags.remove(OTEL_SERVICE_NAME_KEY);
        tags.putIfAbsent("application", DEFAULT_APPLICATION_NAME);
        tags.putIfAbsent("cluster", "none");
        tags.putIfAbsent("shard", "none");
        for (Map.Entry<String, String> tagEntry : tags.entrySet()) {
            requiredTags.add(Annotation.newBuilder().setKey(tagEntry.getKey()).setValue(tagEntry.getValue()).build());
        }
        return requiredTags;
    }

    static long getSpansCount(ExportTraceServiceRequest request) {
        return request.getResourceSpansList().stream().flatMapToLong(r -> r.getScopeSpansList().stream().mapToLong(ScopeSpans::getSpansCount)).sum();
    }

    @VisibleForTesting
    static boolean shouldReportSpanLogs(int logsCount, Pair<Supplier<Boolean>, Counter> spanLogsDisabled) {
        return logsCount > 0 && !FeatureCheckUtils.isFeatureDisabled((Supplier<Boolean>)((Supplier)spanLogsDisabled._1), "Ingested span log discarded because this feature has not been enabled for your account.", (Counter)spanLogsDisabled._2, logsCount);
    }

    @Nullable
    static WavefrontInternalReporter createAndStartInternalReporter(@Nullable WavefrontSender sender) {
        if (sender == null) {
            return null;
        }
        WavefrontInternalReporter reporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource("otlp").reportMinuteDistribution().build(sender);
        reporter.start(1L, TimeUnit.MINUTES);
        return reporter;
    }

    static String fromAnyValue(AnyValue anyValue) {
        if (anyValue.hasStringValue()) {
            return anyValue.getStringValue();
        }
        if (anyValue.hasBoolValue()) {
            return Boolean.toString(anyValue.getBoolValue());
        }
        if (anyValue.hasIntValue()) {
            return Long.toString(anyValue.getIntValue());
        }
        if (anyValue.hasDoubleValue()) {
            return Double.toString(anyValue.getDoubleValue());
        }
        if (anyValue.hasArrayValue()) {
            List values = anyValue.getArrayValue().getValuesList();
            return values.stream().map(OtlpTraceUtils::fromAnyValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (anyValue.hasKvlistValue()) {
            OTLP_DATA_LOGGER.finest(() -> "Encountered KvlistValue but cannot convert to String");
        } else if (anyValue.hasBytesValue()) {
            return Base64.getEncoder().encodeToString(anyValue.getBytesValue().toByteArray());
        }
        return "<Unknown OpenTelemetry attribute value type " + anyValue.getValueCase() + ">";
    }

    static Map<String, String> mapFromAttributes(List<KeyValue> attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValue attribute : attributes) {
            map.put(attribute.getKey(), OtlpTraceUtils.fromAnyValue(attribute.getValue()));
        }
        return map;
    }

    private static Map<String, String> mapFromAnnotations(List<Annotation> annotations) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Annotation annotation : annotations) {
            map.put(annotation.getKey(), annotation.getValue());
        }
        return map;
    }

    private static List<Annotation> annotationsFromStatus(Status otlpStatus) {
        if (otlpStatus.getCode() != Status.StatusCode.STATUS_CODE_ERROR) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> statusAnnotations = new ArrayList<Annotation>();
        statusAnnotations.add(new Annotation("error", "true"));
        if (!otlpStatus.getMessage().isEmpty()) {
            statusAnnotations.add(new Annotation(OTEL_STATUS_DESCRIPTION_KEY, otlpStatus.getMessage()));
        }
        return statusAnnotations;
    }

    private static List<Annotation> annotationsFromTraceState(String state) {
        if (state == null || state.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Annotation("w3c.tracestate", state));
    }

    private static List<Annotation> annotationsFromParentSpanID(ByteString parentSpanId) {
        if (parentSpanId == null || parentSpanId.equals((Object)ByteString.EMPTY)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Annotation("parent", SpanUtils.toStringId(parentSpanId)));
    }

    static class WavefrontSpanAndLogs {
        Span span;
        SpanLogs spanLogs;

        public WavefrontSpanAndLogs(Span span, SpanLogs spanLogs) {
            this.span = span;
            this.spanLogs = spanLogs;
        }

        public Span getSpan() {
            return this.span;
        }

        public SpanLogs getSpanLogs() {
            return this.spanLogs;
        }
    }
}

