/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.google.common.collect.ImmutableMap;
import com.wavefront.agent.logsharvesting.LogsMessage;
import com.wavefront.agent.logsharvesting.MalformedMessageException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.logstash.beats.Message;

public class FilebeatMessage
implements LogsMessage {
    private final Message wrapped;
    private final Map<String, Object> messageData;
    private final Map<String, Object> beatData;
    private final String logLine;
    private Long timestampMillis = null;

    public FilebeatMessage(Message wrapped) throws MalformedMessageException {
        this.wrapped = wrapped;
        this.messageData = this.wrapped.getData();
        this.beatData = (Map)this.messageData.getOrDefault("beat", ImmutableMap.of());
        if (!this.messageData.containsKey("message")) {
            throw new MalformedMessageException("No log line in message.");
        }
        this.logLine = (String)this.messageData.get("message");
        if (this.getTimestampMillis() == null) {
            throw new MalformedMessageException("No timestamp metadata.");
        }
    }

    @Nullable
    public Long getTimestampMillis() {
        if (this.timestampMillis == null) {
            if (!this.messageData.containsKey("@timestamp")) {
                return null;
            }
            String timestampStr = (String)this.messageData.get("@timestamp");
            try {
                TemporalAccessor accessor = DateTimeFormatter.ISO_DATE_TIME.parse(timestampStr);
                this.timestampMillis = Date.from(Instant.from(accessor)).getTime();
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
        return this.timestampMillis;
    }

    @Override
    public String getLogLine() {
        return this.logLine;
    }

    @Override
    public String hostOrDefault(String fallbackHost) {
        Map agentData;
        Map hostData;
        if (this.beatData.containsKey("hostname")) {
            return (String)this.beatData.get("hostname");
        }
        if (this.messageData.containsKey("host") && (hostData = (Map)this.messageData.get("host")).containsKey("name")) {
            return (String)hostData.get("name");
        }
        if (this.messageData.containsKey("agent") && (agentData = (Map)this.messageData.get("agent")).containsKey("hostname")) {
            return (String)agentData.get("hostname");
        }
        return fallbackHost;
    }
}

