/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.config.ConfigurationException;
import com.wavefront.agent.config.LogsIngestionConfig;
import com.wavefront.agent.config.MetricMatcher;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.logsharvesting.EvictingMetricsRegistry;
import com.wavefront.agent.logsharvesting.FlushProcessor;
import com.wavefront.agent.logsharvesting.LogsIngestionConfigManager;
import com.wavefront.agent.logsharvesting.LogsMessage;
import com.wavefront.agent.logsharvesting.MetricsReporter;
import com.wavefront.agent.logsharvesting.ReadProcessor;
import com.wavefront.agent.logsharvesting.ReadProcessorContext;
import com.wavefront.agent.logsharvesting.TimeSeriesUtils;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import wavefront.report.TimeSeries;

public class LogsIngester {
    protected static final Logger logger = Logger.getLogger(LogsIngester.class.getCanonicalName());
    private static final ReadProcessor readProcessor = new ReadProcessor();
    private final FlushProcessor flushProcessor;
    @VisibleForTesting
    final LogsIngestionConfigManager logsIngestionConfigManager;
    private final Counter unparsed;
    private final Counter parsed;
    private final Supplier<Long> currentMillis;
    private final MetricsReporter metricsReporter;
    private EvictingMetricsRegistry evictingMetricsRegistry;

    public LogsIngester(ReportableEntityHandlerFactory handlerFactory, Supplier<LogsIngestionConfig> logsIngestionConfigSupplier, String prefix) throws ConfigurationException {
        this(handlerFactory, logsIngestionConfigSupplier, prefix, System::currentTimeMillis, Ticker.systemTicker());
    }

    @VisibleForTesting
    LogsIngester(ReportableEntityHandlerFactory handlerFactory, Supplier<LogsIngestionConfig> logsIngestionConfigSupplier, String prefix, Supplier<Long> currentMillis, Ticker ticker) throws ConfigurationException {
        this.logsIngestionConfigManager = new LogsIngestionConfigManager(logsIngestionConfigSupplier, removedMetricMatcher -> this.evictingMetricsRegistry.evict((MetricMatcher)removedMetricMatcher));
        LogsIngestionConfig logsIngestionConfig = this.logsIngestionConfigManager.getConfig();
        MetricsRegistry metricsRegistry = new MetricsRegistry();
        this.evictingMetricsRegistry = new EvictingMetricsRegistry(metricsRegistry, logsIngestionConfig.expiryMillis, true, logsIngestionConfig.useDeltaCounters, currentMillis, ticker);
        this.unparsed = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "unparsed"));
        this.parsed = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "parsed"));
        this.currentMillis = currentMillis;
        this.flushProcessor = new FlushProcessor(currentMillis, logsIngestionConfig.useWavefrontHistograms, logsIngestionConfig.reportEmptyHistogramStats);
        this.metricsReporter = new MetricsReporter(metricsRegistry, this.flushProcessor, "FilebeatMetricsReporter", handlerFactory, prefix);
    }

    public void start() {
        long interval = this.logsIngestionConfigManager.getConfig().aggregationIntervalSeconds.intValue();
        this.metricsReporter.start(interval, TimeUnit.SECONDS);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this.evictingMetricsRegistry::cleanUp, interval * 3L / 2L, Math.max(60L, interval * 2L), TimeUnit.SECONDS);
    }

    public void flush() {
        this.metricsReporter.run();
    }

    @VisibleForTesting
    MetricsReporter getMetricsReporter() {
        return this.metricsReporter;
    }

    public void ingestLog(LogsMessage logsMessage) {
        LogsIngestionConfig logsIngestionConfig = this.logsIngestionConfigManager.getConfig();
        boolean success = false;
        for (MetricMatcher metricMatcher : logsIngestionConfig.counters) {
            success |= this.maybeIngestLog(this.evictingMetricsRegistry::getCounter, metricMatcher, logsMessage);
        }
        for (MetricMatcher metricMatcher : logsIngestionConfig.gauges) {
            success |= this.maybeIngestLog(this.evictingMetricsRegistry::getGauge, metricMatcher, logsMessage);
        }
        for (MetricMatcher metricMatcher : logsIngestionConfig.histograms) {
            success |= this.maybeIngestLog(this.evictingMetricsRegistry::getHistogram, metricMatcher, logsMessage);
        }
        if (success) {
            this.parsed.inc();
        } else {
            this.unparsed.inc();
        }
    }

    private boolean maybeIngestLog(BiFunction<MetricName, MetricMatcher, Metric> metricLoader, MetricMatcher metricMatcher, LogsMessage logsMessage) {
        Double[] output = new Double[]{null};
        TimeSeries timeSeries = metricMatcher.timeSeries(logsMessage, output);
        if (timeSeries == null) {
            return false;
        }
        MetricName metricName = TimeSeriesUtils.toMetricName(timeSeries);
        Metric metric = metricLoader.apply(metricName, metricMatcher);
        try {
            metric.processWith((MetricProcessor)readProcessor, metricName, (Object)new ReadProcessorContext(output[0]));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not process metric " + metricName.toString(), e);
        }
        return true;
    }
}

