/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.wavefront.predicates.ExpressionPredicate;
import com.wavefront.predicates.PredicateEvalExpression;
import com.wavefront.predicates.StringComparisonExpression;
import com.wavefront.predicates.StringExpression;
import com.wavefront.predicates.TemplateStringExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class Predicates {
    @VisibleForTesting
    static final String[] LOGICAL_OPS = new String[]{"all", "any", "none", "ignore"};

    private Predicates() {
    }

    @Nullable
    public static <T> Predicate<T> getPredicate(Map<String, Object> ruleMap) {
        Object value = ruleMap.get("if");
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return com.wavefront.predicates.Predicates.fromPredicateEvalExpression((String)((String)value));
        }
        if (value instanceof Map) {
            Map v2PredicateMap = (Map)value;
            Preconditions.checkArgument((v2PredicateMap.size() == 1 ? 1 : 0) != 0, (Object)("Argument [if] can have only 1 top level predicate, but found :: " + v2PredicateMap.size() + "."));
            return Predicates.parsePredicate(v2PredicateMap);
        }
        throw new IllegalArgumentException("Argument [if] value can only be String or Map, got " + value.getClass().getCanonicalName());
    }

    @VisibleForTesting
    static <T> Predicate<T> parsePredicate(Map<String, Object> v2Predicate) {
        if (v2Predicate != null && !v2Predicate.isEmpty()) {
            return new ExpressionPredicate(Predicates.processLogicalOp(v2Predicate));
        }
        return x -> true;
    }

    private static PredicateEvalExpression processLogicalOp(Map<String, Object> element) {
        Iterator<Map.Entry<String, Object>> iterator = element.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Object> tlEntry = iterator.next();
            switch (tlEntry.getKey()) {
                case "all": {
                    List<PredicateEvalExpression> allOps = Predicates.processOperation(tlEntry);
                    return entity -> PredicateEvalExpression.asDouble((boolean)allOps.stream().allMatch(x -> PredicateEvalExpression.isTrue((double)x.getValue(entity))));
                }
                case "any": {
                    List<PredicateEvalExpression> anyOps = Predicates.processOperation(tlEntry);
                    return entity -> PredicateEvalExpression.asDouble((boolean)anyOps.stream().anyMatch(x -> PredicateEvalExpression.isTrue((double)x.getValue(entity))));
                }
                case "none": {
                    List<PredicateEvalExpression> noneOps = Predicates.processOperation(tlEntry);
                    return entity -> PredicateEvalExpression.asDouble((boolean)noneOps.stream().noneMatch(x -> PredicateEvalExpression.isTrue((double)x.getValue(entity))));
                }
                case "ignore": {
                    return x -> 1.0;
                }
            }
            return Predicates.processComparisonOp(tlEntry);
        }
        return x -> 0.0;
    }

    private static List<PredicateEvalExpression> processOperation(Map.Entry<String, Object> tlEntry) {
        ArrayList<PredicateEvalExpression> ops = new ArrayList<PredicateEvalExpression>();
        for (Map tlValue : (List)tlEntry.getValue()) {
            for (Map.Entry<String, Object> entry : tlValue.entrySet()) {
                if (((Stream)Arrays.stream(LOGICAL_OPS).parallel()).anyMatch(((String)entry.getKey())::equals)) {
                    ops.add(Predicates.processLogicalOp(tlValue));
                    continue;
                }
                ops.add(Predicates.processComparisonOp(entry));
            }
        }
        return ops;
    }

    private static PredicateEvalExpression processComparisonOp(Map.Entry<String, Object> subElement) {
        Map svpair = (Map)subElement.getValue();
        if (svpair.size() != 2) {
            throw new IllegalArgumentException("Argument [ + " + subElement.getKey() + "] can have only 2 elements, but found :: " + svpair.size() + ".");
        }
        Object ruleVal = svpair.get("value");
        String scope = (String)svpair.get("scope");
        if (scope == null) {
            throw new IllegalArgumentException("Argument [scope] can't be null/blank.");
        }
        if (ruleVal == null) {
            throw new IllegalArgumentException("Argument [value] can't be null/blank.");
        }
        if (ruleVal instanceof List) {
            List options = ((List)ruleVal).stream().map(option -> StringComparisonExpression.of((StringExpression)new TemplateStringExpression("{{" + scope + "}}"), x -> option, (String)((String)subElement.getKey()))).collect(Collectors.toList());
            return entity -> PredicateEvalExpression.asDouble((boolean)options.stream().anyMatch(x -> PredicateEvalExpression.isTrue((double)x.getValue(entity))));
        }
        if (ruleVal instanceof String) {
            return StringComparisonExpression.of((StringExpression)new TemplateStringExpression("{{" + scope + "}}"), x -> (String)ruleVal, (String)subElement.getKey());
        }
        throw new IllegalArgumentException("[value] can only be String or List, got " + ruleVal.getClass().getCanonicalName());
    }
}

