/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.LengthLimitActionType;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.preprocessor.PreprocessorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogLimitLengthTransformer
implements Function<ReportLog, ReportLog> {
    private final String scope;
    private final int maxLength;
    private final LengthLimitActionType actionSubtype;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final Predicate<ReportLog> v2Predicate;
    private final PreprocessorRuleMetrics ruleMetrics;

    public ReportLogLimitLengthTransformer(@Nonnull String scope, int maxLength, @Nonnull LengthLimitActionType actionSubtype, @Nullable String patternMatch, @Nullable Predicate<ReportLog> v2Predicate, @Nonnull PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        if (actionSubtype == LengthLimitActionType.DROP && (scope.equals("message") || scope.equals("sourceName"))) {
            throw new IllegalArgumentException("'drop' action type can't be used in message and sourceName scope!");
        }
        if (actionSubtype == LengthLimitActionType.TRUNCATE_WITH_ELLIPSIS && maxLength < 3) {
            throw new IllegalArgumentException("'maxLength' must be at least 3 for 'truncateWithEllipsis' action type!");
        }
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"[maxLength] needs to be > 0!");
        this.maxLength = maxLength;
        this.actionSubtype = actionSubtype;
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            switch (this.scope) {
                case "message": {
                    if (reportLog.getMessage().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getMessage()).matches()) break;
                    reportLog.setMessage(PreprocessorUtil.truncate(reportLog.getMessage(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (reportLog.getHost().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getHost()).matches()) break;
                    reportLog.setHost(PreprocessorUtil.truncate(reportLog.getHost(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    ArrayList annotations = new ArrayList(reportLog.getAnnotations());
                    Iterator iterator = annotations.iterator();
                    boolean changed = false;
                    while (iterator.hasNext()) {
                        Annotation entry = (Annotation)iterator.next();
                        if (!entry.getKey().equals(this.scope) || entry.getValue().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(entry.getValue()).matches()) continue;
                        changed = true;
                        if (this.actionSubtype == LengthLimitActionType.DROP) {
                            iterator.remove();
                        } else {
                            entry.setValue(PreprocessorUtil.truncate(entry.getValue(), this.maxLength, this.actionSubtype));
                        }
                        this.ruleMetrics.incrementRuleAppliedCounter();
                    }
                    if (!changed) break;
                    reportLog.setAnnotations(annotations);
                }
            }
            String string = reportLog;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

