/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointExtractTagTransformer
implements Function<ReportPoint, ReportPoint> {
    protected final String tag;
    protected final String source;
    protected final String patternReplace;
    protected final Pattern compiledSearchPattern;
    @Nullable
    protected final Pattern compiledMatchPattern;
    @Nullable
    protected final String patternReplaceSource;
    protected final PreprocessorRuleMetrics ruleMetrics;
    protected final Predicate<ReportPoint> v2Predicate;

    public ReportPointExtractTagTransformer(String tag, String source, String patternSearch, String patternReplace, @Nullable String replaceSource, @Nullable String patternMatch, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null");
        this.source = (String)Preconditions.checkNotNull((Object)source, (Object)"[source] can't be null");
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        Preconditions.checkArgument((!source.isEmpty() ? 1 : 0) != 0, (Object)"[source] can't be blank");
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.patternReplaceSource = replaceSource;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    protected boolean extractTag(@Nonnull ReportPoint reportPoint, String extractFrom) {
        if (extractFrom == null || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(extractFrom).matches()) {
            return false;
        }
        Matcher patternMatcher = this.compiledSearchPattern.matcher(extractFrom);
        if (!patternMatcher.find()) {
            return false;
        }
        String value = patternMatcher.replaceAll(Util.expandPlaceholders((String)this.patternReplace, (ReportPoint)reportPoint));
        if (!value.isEmpty()) {
            reportPoint.getAnnotations().put(this.tag, value);
            this.ruleMetrics.incrementRuleAppliedCounter();
        }
        return true;
    }

    protected void internalApply(@Nonnull ReportPoint reportPoint) {
        switch (this.source) {
            case "metricName": {
                this.applyMetricName(reportPoint);
                break;
            }
            case "sourceName": {
                this.applySourceName(reportPoint);
                break;
            }
            case "pointLine": {
                this.applyMetricName(reportPoint);
                this.applySourceName(reportPoint);
                this.applyPointLineTag(reportPoint);
                break;
            }
            default: {
                this.applyPointTagKey(reportPoint, this.source);
            }
        }
    }

    public void applyMetricName(ReportPoint reportPoint) {
        if (this.extractTag(reportPoint, reportPoint.getMetric()) && this.patternReplaceSource != null) {
            reportPoint.setMetric(this.compiledSearchPattern.matcher(reportPoint.getMetric()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceSource, (ReportPoint)reportPoint)));
        }
    }

    public void applySourceName(ReportPoint reportPoint) {
        if (this.extractTag(reportPoint, reportPoint.getHost()) && this.patternReplaceSource != null) {
            reportPoint.setHost(this.compiledSearchPattern.matcher(reportPoint.getHost()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceSource, (ReportPoint)reportPoint)));
        }
    }

    public void applyPointLineTag(ReportPoint reportPoint) {
        if (reportPoint.getAnnotations() != null) {
            for (Map.Entry pointTag : reportPoint.getAnnotations().entrySet()) {
                if (!this.extractTag(reportPoint, (String)pointTag.getKey()) && !this.extractTag(reportPoint, (String)pointTag.getValue()) || this.patternReplaceSource == null) continue;
                reportPoint.getAnnotations().put((String)pointTag.getKey(), this.compiledSearchPattern.matcher((CharSequence)reportPoint.getAnnotations().get(pointTag.getKey())).replaceAll(Util.expandPlaceholders((String)this.patternReplaceSource, (ReportPoint)reportPoint)));
            }
        }
    }

    public void applyPointTagKey(ReportPoint reportPoint, String tagKey) {
        if (reportPoint.getAnnotations() != null && reportPoint.getAnnotations().get(tagKey) != null && this.extractTag(reportPoint, (String)reportPoint.getAnnotations().get(tagKey)) && this.patternReplaceSource != null) {
            reportPoint.getAnnotations().put(tagKey, this.compiledSearchPattern.matcher((CharSequence)reportPoint.getAnnotations().get(tagKey)).replaceAll(Util.expandPlaceholders((String)this.patternReplaceSource, (ReportPoint)reportPoint)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            this.internalApply(reportPoint);
            ReportPoint reportPoint3 = reportPoint;
            return reportPoint3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

