/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointForceLowercaseTransformer
implements Function<ReportPoint, ReportPoint> {
    private final String scope;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportPoint> v2Predicate;

    public ReportPointForceLowercaseTransformer(String scope, @Nullable String patternMatch, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            switch (this.scope) {
                case "metricName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getMetric()).matches()) break;
                    reportPoint.setMetric(reportPoint.getMetric().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getHost()).matches()) break;
                    reportPoint.setHost(reportPoint.getHost().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    String tagValue;
                    if (reportPoint.getAnnotations() == null || (tagValue = (String)reportPoint.getAnnotations().get(this.scope)) == null || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(tagValue).matches()) break;
                    reportPoint.getAnnotations().put(this.scope, tagValue.toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                }
            }
            String string = reportPoint;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

