/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.preprocessor.AnnotatedPredicate;
import com.wavefront.common.Clock;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointTimestampInRangeFilter
implements AnnotatedPredicate<ReportPoint> {
    private final int hoursInPastAllowed;
    private final int hoursInFutureAllowed;
    private final Supplier<Long> timeSupplier;
    private final Counter outOfRangePointTimes;

    public ReportPointTimestampInRangeFilter(int hoursInPastAllowed, int hoursInFutureAllowed) {
        this(hoursInPastAllowed, hoursInFutureAllowed, Clock::now);
    }

    @VisibleForTesting
    ReportPointTimestampInRangeFilter(int hoursInPastAllowed, int hoursInFutureAllowed, @Nonnull Supplier<Long> timeProvider) {
        this.hoursInPastAllowed = hoursInPastAllowed;
        this.hoursInFutureAllowed = hoursInFutureAllowed;
        this.timeSupplier = timeProvider;
        this.outOfRangePointTimes = Metrics.newCounter((MetricName)new MetricName("point", "", "badtime"));
    }

    @Override
    public boolean test(@Nonnull ReportPoint point, @Nullable String[] messageHolder) {
        long rightNow;
        long pointTime = point.getTimestamp();
        if (pointTime > (rightNow = this.timeSupplier.get().longValue()) - TimeUnit.HOURS.toMillis(this.hoursInPastAllowed) && pointTime < rightNow + TimeUnit.HOURS.toMillis(this.hoursInFutureAllowed)) {
            return true;
        }
        this.outOfRangePointTimes.inc();
        if (messageHolder != null && messageHolder.length > 0) {
            messageHolder[0] = "WF-402: Point outside of reasonable timeframe (" + point.toString() + ")";
        }
        return false;
    }
}

