/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanDropAnnotationTransformer
implements Function<Span, Span> {
    private final Pattern compiledKeyPattern;
    @Nullable
    private final Pattern compiledValuePattern;
    private final boolean firstMatchOnly;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    public SpanDropAnnotationTransformer(String key, @Nullable String patternMatch, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledKeyPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)key, (Object)"[key] can't be null"));
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"[key] can't be blank");
        this.compiledValuePattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.firstMatchOnly = firstMatchOnly;
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            ArrayList annotations = new ArrayList(span.getAnnotations());
            Iterator iterator = annotations.iterator();
            boolean changed = false;
            while (iterator.hasNext()) {
                Annotation entry = (Annotation)iterator.next();
                if (!this.compiledKeyPattern.matcher(entry.getKey()).matches() || this.compiledValuePattern != null && !this.compiledValuePattern.matcher(entry.getValue()).matches()) continue;
                changed = true;
                iterator.remove();
                this.ruleMetrics.incrementRuleAppliedCounter();
                if (!this.firstMatchOnly) continue;
                break;
            }
            if (changed) {
                span.setAnnotations(annotations);
            }
            Span span3 = span;
            return span3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

