/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanForceLowercaseTransformer
implements Function<Span, Span> {
    private final String scope;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final boolean firstMatchOnly;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    public SpanForceLowercaseTransformer(String scope, @Nullable String patternMatch, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.firstMatchOnly = firstMatchOnly;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            block6 : switch (this.scope) {
                case "spanName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getName()).matches()) break;
                    span.setName(span.getName().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(span.getSource()).matches()) break;
                    span.setSource(span.getSource().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    for (Annotation x : span.getAnnotations()) {
                        if (!x.getKey().equals(this.scope) || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(x.getValue()).matches()) continue;
                        x.setValue(x.getValue().toLowerCase());
                        this.ruleMetrics.incrementRuleAppliedCounter();
                        if (!this.firstMatchOnly) continue;
                        break block6;
                    }
                }
            }
            String string = span;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

