/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.agent.data.EventDataSubmissionTask;
import com.wavefront.agent.data.LineDelimitedDataSubmissionTask;
import com.wavefront.agent.data.SourceTagSubmissionTask;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.queueing.ConcurrentShardedQueueFile;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.agent.queueing.TaskQueueFactory;
import com.wavefront.agent.queueing.TaskQueueStub;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.dto.Event;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.NumberUtils;

public class QueueExporter {
    private static final Logger logger = Logger.getLogger(QueueExporter.class.getCanonicalName());
    private static final Pattern FILENAME = Pattern.compile("^(.*)\\.(\\w+)\\.(\\w+)\\.(\\w+)\\.(\\w+)$");
    private final String bufferFile;
    private final String exportQueuePorts;
    private final String exportQueueOutputFile;
    private final boolean retainData;
    private final TaskQueueFactory taskQueueFactory;
    private final EntityPropertiesFactory entityPropertiesFactory;

    public QueueExporter(String bufferFile, String exportQueuePorts, String exportQueueOutputFile, boolean retainData, TaskQueueFactory taskQueueFactory, EntityPropertiesFactory entityPropertiesFactory) {
        this.bufferFile = bufferFile;
        this.exportQueuePorts = exportQueuePorts;
        this.exportQueueOutputFile = exportQueueOutputFile;
        this.retainData = retainData;
        this.taskQueueFactory = taskQueueFactory;
        this.entityPropertiesFactory = entityPropertiesFactory;
    }

    public void export() {
        Set<HandlerKey> handlerKeys = QueueExporter.getValidHandlerKeys(ConcurrentShardedQueueFile.listFiles(this.bufferFile, ".spool"), this.exportQueuePorts);
        handlerKeys.forEach(this::processHandlerKey);
    }

    @VisibleForTesting
    <T extends DataSubmissionTask<T>> void processHandlerKey(HandlerKey key) {
        logger.info("Processing " + key.getEntityType() + " queue for port " + key.getHandle());
        int threads = this.entityPropertiesFactory.get(key.getEntityType()).getFlushThreads();
        for (int i = 0; i < threads; ++i) {
            TaskQueue taskQueue = this.taskQueueFactory.getTaskQueue(key, i);
            if (taskQueue instanceof TaskQueueStub) continue;
            String outputFileName = this.exportQueueOutputFile + "." + key.getEntityType() + "." + key.getHandle() + "." + i + ".txt";
            logger.info("Exporting data to " + outputFileName);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));
                this.processQueue(taskQueue, writer);
                writer.close();
                taskQueue.close();
                continue;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IO error", e);
            }
        }
    }

    @VisibleForTesting
    <T extends DataSubmissionTask<T>> void processQueue(TaskQueue<T> queue, BufferedWriter writer) throws IOException {
        int tasksProcessed = 0;
        int itemsExported = 0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            DataSubmissionTask task = (DataSubmissionTask)iterator.next();
            this.processTask(task, writer);
            if (!this.retainData) {
                iterator.remove();
            }
            ++tasksProcessed;
            itemsExported += task.weight();
        }
        logger.info(tasksProcessed + " tasks, " + itemsExported + " items exported");
    }

    @VisibleForTesting
    <T extends DataSubmissionTask<T>> void processTask(T task, BufferedWriter writer) throws IOException {
        block3: {
            block4: {
                block2: {
                    if (!(task instanceof LineDelimitedDataSubmissionTask)) break block2;
                    for (String line : ((LineDelimitedDataSubmissionTask)task).payload()) {
                        writer.write(line);
                        writer.newLine();
                    }
                    break block3;
                }
                if (!(task instanceof SourceTagSubmissionTask)) break block4;
                writer.write(((SourceTagSubmissionTask)task).payload().toString());
                writer.newLine();
                break block3;
            }
            if (!(task instanceof EventDataSubmissionTask)) break block3;
            for (Event event : ((EventDataSubmissionTask)task).payload()) {
                writer.write(event.toString());
                writer.newLine();
            }
        }
    }

    @VisibleForTesting
    static Set<HandlerKey> getValidHandlerKeys(@Nullable List<String> files, String portList) {
        if (files == null) {
            return Collections.emptySet();
        }
        HashSet ports = new HashSet(Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)portList));
        HashSet<HandlerKey> out = new HashSet<HandlerKey>();
        files.forEach(x -> {
            Matcher matcher = FILENAME.matcher((CharSequence)x);
            if (matcher.matches()) {
                ReportableEntityType type = ReportableEntityType.fromString((String)matcher.group(2));
                String handle = matcher.group(3);
                if (type != null && NumberUtils.isDigits((String)matcher.group(4)) && !handle.startsWith("_") && (portList.equalsIgnoreCase("all") || ports.contains(handle))) {
                    out.add(HandlerKey.of(type, handle));
                }
            }
        });
        return out;
    }
}

