/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.TaskConverter;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.common.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SQSSubmissionQueue<T extends DataSubmissionTask<T>>
implements TaskQueue<T> {
    private static final Logger log = Logger.getLogger(SQSSubmissionQueue.class.getCanonicalName());
    private final String queueUrl;
    private final TaskConverter<T> converter;
    private final AmazonSQS sqsClient;
    private volatile String messageHandle = null;
    private volatile T head = null;

    public SQSSubmissionQueue(String queueUrl, AmazonSQS sqsClient, TaskConverter<T> converter) {
        this.queueUrl = queueUrl;
        this.converter = converter;
        this.sqsClient = sqsClient;
    }

    @Override
    public T peek() {
        try {
            if (this.head != null) {
                return this.head;
            }
            ReceiveMessageRequest receiveRequest = new ReceiveMessageRequest(this.queueUrl);
            receiveRequest.setMaxNumberOfMessages(Integer.valueOf(1));
            receiveRequest.setWaitTimeSeconds(Integer.valueOf(1));
            ReceiveMessageResult result = this.sqsClient.receiveMessage(receiveRequest);
            List messages = result.getMessages();
            if (messages.size() <= 0) {
                return null;
            }
            Message message = (Message)messages.get(0);
            byte[] messageBytes = DatatypeConverter.parseBase64Binary((String)message.getBody());
            this.messageHandle = message.getReceiptHandle();
            this.head = (DataSubmissionTask)this.converter.fromBytes(messageBytes);
            return this.head;
        }
        catch (IOException e) {
            throw (Error)Utils.throwAny(e);
        }
        catch (AmazonClientException e) {
            throw (Error)Utils.throwAny(new IOException("AmazonClientException while trying to peek the queues, ", e));
        }
    }

    @Override
    public void add(@Nonnull T t) throws IOException {
        try {
            SendMessageRequest request = new SendMessageRequest();
            String contents = this.encodeMessageForDelivery(t);
            request.setMessageBody(contents);
            request.setQueueUrl(this.queueUrl);
            this.sqsClient.sendMessage(request);
        }
        catch (AmazonClientException e) {
            throw new IOException("AmazonClientException adding messages onto the queue", e);
        }
    }

    @VisibleForTesting
    public String encodeMessageForDelivery(T t) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.converter.serializeToStream(t, os);
            byte[] contents = os.toByteArray();
            String string = DatatypeConverter.printBase64Binary((byte[])contents);
            return string;
        }
    }

    @Override
    public void remove() throws IOException {
        try {
            if (StringUtils.isBlank((CharSequence)this.messageHandle) || this.head == null) {
                return;
            }
            int taskSize = this.head.weight();
            DeleteMessageRequest deleteRequest = new DeleteMessageRequest(this.queueUrl, this.messageHandle);
            this.sqsClient.deleteMessage(deleteRequest);
            this.head = null;
            this.messageHandle = null;
        }
        catch (AmazonClientException e) {
            throw new IOException("AmazonClientException removing from the queue", e);
        }
    }

    @Override
    public void clear() throws IOException {
        try {
            this.sqsClient.purgeQueue(new PurgeQueueRequest(this.queueUrl));
        }
        catch (AmazonClientException e) {
            throw new IOException("AmazonClientException clearing the queue", e);
        }
    }

    @Override
    public int size() {
        int queueSize = 0;
        try {
            GetQueueAttributesRequest request = new GetQueueAttributesRequest(this.queueUrl);
            request.withAttributeNames(new QueueAttributeName[]{QueueAttributeName.ApproximateNumberOfMessages});
            GetQueueAttributesResult result = this.sqsClient.getQueueAttributes(request);
            queueSize = Integer.parseInt(result.getAttributes().getOrDefault(QueueAttributeName.ApproximateNumberOfMessages.toString(), "0"));
        }
        catch (AmazonClientException e) {
            log.log(Level.SEVERE, "Unable to obtain ApproximateNumberOfMessages from queue", e);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "Value returned for approximate number of messages is not a valid number", e);
        }
        return queueSize;
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public Long weight() {
        return null;
    }

    @Override
    @Nullable
    public Long getAvailableBytes() {
        throw new UnsupportedOperationException("Cannot obtain total bytes from SQS queue, consider using size instead");
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("iterator() is not supported on a SQS queue");
    }
}

