/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.IgnoredHtmlElement;
import com.overzealous.remark.Options;
import com.overzealous.remark.convert.Abbr;
import com.overzealous.remark.convert.Anchor;
import com.overzealous.remark.convert.BlockQuote;
import com.overzealous.remark.convert.Break;
import com.overzealous.remark.convert.Codeblock;
import com.overzealous.remark.convert.DefaultNodeHandler;
import com.overzealous.remark.convert.Definitions;
import com.overzealous.remark.convert.Header;
import com.overzealous.remark.convert.HorizontalRule;
import com.overzealous.remark.convert.Image;
import com.overzealous.remark.convert.InlineCode;
import com.overzealous.remark.convert.InlineStyle;
import com.overzealous.remark.convert.List;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.NodeRemover;
import com.overzealous.remark.convert.Paragraph;
import com.overzealous.remark.convert.Table;
import com.overzealous.remark.convert.TextCleaner;
import com.overzealous.remark.util.BlockWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class DocumentConverter {
    final Options options;
    final TextCleaner cleaner;
    private final Set<String> ignoredHtmlTags;
    final Map<String, NodeHandler> blockNodes;
    final Map<String, NodeHandler> inlineNodes;
    private Map<String, String> linkUrls;
    private int genericLinkUrlCounter;
    private int genericImageUrlCounter;
    private Map<String, String> linkIds;
    private Map<String, String> abbreviations;
    BlockWriter output;
    private Map<String, NodeHandler> lastNodeset;
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern LINK_MULTIPLE_SPACES = Pattern.compile(" {2,}", 32);
    private static final Pattern LINK_SAFE_CHARS = Pattern.compile("[^-\\w \\.]+", 32);
    private static final String LINK_REPLACEMENT = "_";
    private static final Pattern LINK_EDGE_REPLACE = Pattern.compile(String.format("(^%1$s++)|(%1$s++$)", "_"));
    private static final Pattern LINK_MULTIPLE_REPLACE = Pattern.compile(String.format("%1$s{2,}", "_"));
    private static final Pattern LINK_FILENAME = Pattern.compile("/([^/]++)$");

    public DocumentConverter(Options options) {
        this.options = options;
        this.cleaner = new TextCleaner(options);
        this.ignoredHtmlTags = new HashSet<String>();
        this.blockNodes = new HashMap<String, NodeHandler>();
        this.inlineNodes = new HashMap<String, NodeHandler>();
        for (IgnoredHtmlElement ihe : options.getIgnoredHtmlElements()) {
            this.ignoredHtmlTags.add(ihe.getTagName());
        }
        this.configureNodes();
    }

    private void configureNodes() {
        this.addInlineNode(new InlineStyle(), "i,em,b,strong,font,span,del,strike,s");
        this.addInlineNode(new InlineCode(), "code,tt");
        this.addInlineNode(new Image(), "img");
        this.addInlineNode(new Anchor(), "a");
        this.addInlineNode(new Break(), "br");
        this.addBlockNode(new Header(), "h1,h2,h3,h4,h5,h6");
        this.addBlockNode(new Paragraph(), "p");
        this.addBlockNode(new Codeblock(), "pre");
        this.addBlockNode(new BlockQuote(), "blockquote");
        this.addBlockNode(new HorizontalRule(), "hr");
        this.addBlockNode(new List(), "ol,ul");
        if (this.options.abbreviations) {
            this.addInlineNode(new Abbr(), "abbr,acronym");
        }
        if (this.options.definitionLists) {
            this.addBlockNode(new Definitions(), "dl");
        }
        if (this.options.getTables().isConvertedToText()) {
            this.addBlockNode(new Table(), "table");
        } else if (this.options.getTables().isRemoved()) {
            this.addBlockNode(NodeRemover.getInstance(), "table");
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public TextCleaner getCleaner() {
        return this.cleaner;
    }

    public Map<String, NodeHandler> getBlockNodes() {
        return Collections.unmodifiableMap(this.blockNodes);
    }

    public Map<String, NodeHandler> getInlineNodes() {
        return Collections.unmodifiableMap(this.inlineNodes);
    }

    public BlockWriter getOutput() {
        return this.output;
    }

    public void setOutput(BlockWriter output) {
        this.output = output;
    }

    public void addInlineNode(NodeHandler handler, String tagnames) {
        for (String key : COMMA.split(tagnames)) {
            if (key.length() <= 0) continue;
            this.inlineNodes.put(key, handler);
            this.blockNodes.put(key, handler);
        }
    }

    public void addBlockNode(NodeHandler handler, String tagnames) {
        for (String key : COMMA.split(tagnames)) {
            if (key.length() <= 0) continue;
            this.blockNodes.put(key, handler);
        }
    }

    public void convert(Document doc, Writer out) {
        this.output = new BlockWriter(out, true);
        this.convertImpl(doc);
    }

    public void convert(Document doc, OutputStream out) {
        this.output = new BlockWriter(out, true);
        this.convertImpl(doc);
    }

    public String convert(Document doc) {
        BlockWriter bw;
        this.output = bw = BlockWriter.create(DocumentConverter.calculateLength((Element)doc, 0));
        this.convertImpl(doc);
        return bw.toString();
    }

    private static int calculateLength(Element el, int depth) {
        int result = 0;
        for (Node n : el.childNodes()) {
            if (n instanceof Element) {
                result += 4 * depth + DocumentConverter.calculateLength((Element)n, depth + 1);
                continue;
            }
            if (!(n instanceof TextNode)) continue;
            result += ((TextNode)n).text().length();
        }
        return result;
    }

    private void convertImpl(Document doc) {
        this.linkIds = new LinkedHashMap<String, String>();
        this.linkUrls = new HashMap<String, String>();
        this.genericImageUrlCounter = 0;
        this.genericLinkUrlCounter = 0;
        this.abbreviations = new LinkedHashMap<String, String>();
        this.lastNodeset = this.blockNodes;
        this.walkNodes(DefaultNodeHandler.getInstance(), doc.body(), this.blockNodes);
        if (!this.linkIds.isEmpty()) {
            this.output.startBlock();
            for (Map.Entry<String, String> link : this.linkIds.entrySet()) {
                this.output.printf("\n[%s]: %s", link.getKey(), link.getValue());
            }
            this.output.endBlock();
        }
        if (!this.abbreviations.isEmpty()) {
            this.output.startBlock();
            for (Map.Entry<String, String> abbr : this.abbreviations.entrySet()) {
                this.output.printf("\n*[%s]: %s", abbr.getKey(), this.cleaner.clean(abbr.getValue()));
            }
            this.output.endBlock();
        }
        this.linkIds = null;
        this.linkUrls = null;
        this.abbreviations = null;
        this.output = null;
    }

    public void walkNodes(NodeHandler currentNode, Element el) {
        this.walkNodes(currentNode, el, this.lastNodeset);
    }

    public void walkNodes(NodeHandler currentNodeHandler, Element el, Map<String, NodeHandler> nodeList) {
        Map<String, NodeHandler> backupLastNodeset = this.lastNodeset;
        this.lastNodeset = nodeList;
        for (Node n : el.childNodes()) {
            if (n instanceof TextNode) {
                currentNodeHandler.handleTextNode((TextNode)n, this);
                continue;
            }
            if (!(n instanceof Element)) continue;
            Element node = (Element)n;
            String tagName = node.tagName();
            if (nodeList.containsKey(tagName)) {
                nodeList.get(tagName).handleNode(currentNodeHandler, node, this);
                continue;
            }
            if (this.ignoredHtmlTags.contains(tagName)) {
                currentNodeHandler.handleIgnoredHTMLElement(node, this);
                continue;
            }
            if (node.isBlock()) {
                this.output.startBlock();
            }
            this.walkNodes(currentNodeHandler, node, nodeList);
            if (!node.isBlock()) continue;
            this.output.endBlock();
        }
        this.lastNodeset = backupLastNodeset;
    }

    public String getInlineContent(NodeHandler currentNode, Element el) {
        return this.getInlineContent(currentNode, el, false);
    }

    public String getInlineContent(NodeHandler currentNode, Element el, boolean undoLeadingEscapes) {
        BlockWriter oldOutput = this.output;
        this.output = BlockWriter.create(1000);
        this.walkNodes(currentNode, el, this.inlineNodes);
        String ret = this.output.toString();
        this.output = oldOutput;
        if (undoLeadingEscapes) {
            ret = this.cleaner.unescapeLeadingCharacters(ret);
        }
        return ret;
    }

    public String addLink(String url, String recommendedName, boolean image) {
        String linkId;
        if (this.linkUrls.containsKey(url)) {
            linkId = this.linkUrls.get(url);
        } else {
            if (this.options.simpleLinkIds) {
                linkId = (image ? "image-" : "") + String.valueOf(this.linkUrls.size() + 1);
            } else {
                if (this.linkIds.containsKey(recommendedName = this.cleanLinkId(url, recommendedName, image))) {
                    int incr = 1;
                    while (this.linkIds.containsKey(String.format("%s %d", recommendedName, incr))) {
                        ++incr;
                    }
                    recommendedName = String.format("%s %d", recommendedName, incr);
                }
                linkId = recommendedName;
            }
            this.linkUrls.put(url, linkId);
            this.linkIds.put(linkId, url);
        }
        return linkId;
    }

    void addAbbreviation(String abbr, String definition) {
        if (!this.abbreviations.containsKey(abbr)) {
            this.abbreviations.put(abbr, definition);
        }
    }

    String cleanLinkId(String url, String linkId, boolean image) {
        String ret = linkId.replace('\n', ' ');
        ret = LINK_MULTIPLE_SPACES.matcher(ret).replaceAll(" ");
        ret = LINK_SAFE_CHARS.matcher(ret).replaceAll(LINK_REPLACEMENT);
        ret = LINK_MULTIPLE_REPLACE.matcher(ret).replaceAll(LINK_REPLACEMENT);
        ret = LINK_EDGE_REPLACE.matcher(ret).replaceAll("");
        if ((ret = ret.trim()).length() == 0 || ret.equals(LINK_REPLACEMENT)) {
            if (image) {
                if (url != null) {
                    Matcher m = LINK_FILENAME.matcher(url);
                    if (m.find()) {
                        ret = this.cleanLinkId(null, m.group(1), true);
                    } else {
                        ++this.genericImageUrlCounter;
                        ret = "Image " + this.genericImageUrlCounter;
                    }
                } else {
                    ++this.genericImageUrlCounter;
                    ret = "Image " + this.genericImageUrlCounter;
                }
            } else {
                ++this.genericLinkUrlCounter;
                ret = "Link " + this.genericLinkUrlCounter;
            }
        }
        return ret;
    }
}

