/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Gauge;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricRegistry;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ThreadStatesGaugeSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Gauge<Object>> gauges = new HashMap<MetricName, Gauge<Object>>();
        for (Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name(state.toString().toLowerCase(), "count"), () -> this.getThreadCount(state));
        }
        gauges.put(MetricName.build("count"), this.threads::getThreadCount);
        gauges.put(MetricName.build("daemon.count"), this.threads::getDaemonThreadCount);
        gauges.put(MetricName.build("peak.count"), this.threads::getPeakThreadCount);
        gauges.put(MetricName.build("total_started.count"), this.threads::getTotalStartedThreadCount);
        gauges.put(MetricName.build("deadlock.count"), () -> this.deadlockDetector.getDeadlockedThreads().size());
        gauges.put(MetricName.build("deadlocks"), this.deadlockDetector::getDeadlockedThreads);
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }
}

