/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal.reporter;

import com.wavefront.internal.EntitiesInstantiator;
import com.wavefront.internal.reporter.Reporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Clock;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Counter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.DeltaCounter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Gauge;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Histogram;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Meter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metered;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricAttribute;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricFilter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricRegistry;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.ScheduledReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.SlidingTimeWindowArrayReservoir;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Snapshot;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Timer;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.WavefrontHistogram;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.BufferPoolMetricSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.ClassLoadingGaugeSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.FileDescriptorRatioGauge;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.GarbageCollectorMetricSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.MemoryUsageGaugeSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.ThreadStatesGaugeSet;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.metrics.WavefrontSdkDeltaCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WavefrontInternalReporter
implements Reporter,
EntitiesInstantiator,
Closeable {
    private static final Logger logger = Logger.getLogger(WavefrontInternalReporter.class.getCanonicalName());
    private final ScheduledReporter scheduledReporter;
    private final MetricRegistry internalRegistry;
    public static final String DEFAULT_SOURCE_WF_INTERNAL_REPORTER = "wavefront-internal-reporter";
    private final WavefrontSender wavefrontSender;
    private final Clock clock;
    private final String prefix;
    private final String source;
    private final Map<String, String> reporterPointTags;
    private final Set<HistogramGranularity> histogramGranularities;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private final WavefrontSdkDeltaCounter gaugesReported;
    private final WavefrontSdkDeltaCounter deltaCountersReported;
    private final WavefrontSdkDeltaCounter countersReported;
    private final WavefrontSdkDeltaCounter wfHistogramsReported;
    private final WavefrontSdkDeltaCounter histogramsReported;
    private final WavefrontSdkDeltaCounter metersReported;
    private final WavefrontSdkDeltaCounter timersReported;
    private final WavefrontSdkDeltaCounter reportErrors;
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    private WavefrontInternalReporter(MetricRegistry registry, WavefrontSender wavefrontSender, String prefix, String source, Map<String, String> reporterPointTags, Set<HistogramGranularity> histogramGranularities, boolean includeJvmMetrics, final Clock clock, ScheduledExecutorService scheduledExecutorService) {
        this.clock = clock;
        this.internalRegistry = registry;
        this.scheduledReporter = new ScheduledReporter(registry, "wavefront-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, scheduledExecutorService, true, Collections.emptySet()){

            @Override
            public void report(SortedMap<MetricName, Gauge<?>> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
                try {
                    long timestamp = clock.getTime();
                    for (Map.Entry<MetricName, Gauge<?>> entry : gauges.entrySet()) {
                        if (!(entry.getValue().getValue() instanceof Number)) continue;
                        WavefrontInternalReporter.this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
                        WavefrontInternalReporter.this.gaugesReported.inc();
                    }
                    for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
                        WavefrontInternalReporter.this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
                        if (entry.getValue() instanceof DeltaCounter) {
                            WavefrontInternalReporter.this.deltaCountersReported.inc();
                            continue;
                        }
                        WavefrontInternalReporter.this.countersReported.inc();
                    }
                    for (Map.Entry<MetricName, Metric> entry : histograms.entrySet()) {
                        WavefrontInternalReporter.this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
                        if (entry.getValue() instanceof WavefrontHistogram) {
                            WavefrontInternalReporter.this.wfHistogramsReported.inc();
                            continue;
                        }
                        WavefrontInternalReporter.this.histogramsReported.inc();
                    }
                    for (Map.Entry<MetricName, Metric> entry : meters.entrySet()) {
                        WavefrontInternalReporter.this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp);
                        WavefrontInternalReporter.this.metersReported.inc();
                    }
                    for (Map.Entry<MetricName, Metric> entry : timers.entrySet()) {
                        WavefrontInternalReporter.this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
                        WavefrontInternalReporter.this.timersReported.inc();
                    }
                }
                catch (IOException e) {
                    WavefrontInternalReporter.this.reportErrors.inc();
                    logger.log(Level.WARNING, "Unable to report to Wavefront", e);
                }
            }
        };
        this.wavefrontSender = wavefrontSender;
        this.prefix = prefix;
        this.source = source;
        this.reporterPointTags = reporterPointTags;
        this.histogramGranularities = histogramGranularities;
        if (includeJvmMetrics) {
            this.tryRegister(registry, "jvm.uptime", () -> ManagementFactory.getRuntimeMXBean().getUptime());
            this.tryRegister(registry, "jvm.current_time", clock::getTime);
            this.tryRegister(registry, "jvm.classes", new ClassLoadingGaugeSet());
            this.tryRegister(registry, "jvm.fd_usage", new FileDescriptorRatioGauge());
            this.tryRegister(registry, "jvm.buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            this.tryRegister(registry, "jvm.gc", new GarbageCollectorMetricSet());
            this.tryRegister(registry, "jvm.memory", new MemoryUsageGaugeSet());
            this.tryRegister(registry, "jvm.thread-states", new ThreadStatesGaugeSet());
        }
        this.sdkMetricsRegistry = new WavefrontSdkMetricsRegistry.Builder((WavefrontMetricSender)this.wavefrontSender).prefix("~sdk.java.internal_reporter").source(this.source).tags(this.reporterPointTags).build();
        double sdkVersion = Utils.getSemVerGauge((String)"wavefront-internal-reporter-java");
        this.sdkMetricsRegistry.newGauge("version", () -> sdkVersion);
        this.gaugesReported = this.sdkMetricsRegistry.newDeltaCounter("gauges.reported");
        this.deltaCountersReported = this.sdkMetricsRegistry.newDeltaCounter("delta_counters.reported");
        this.countersReported = this.sdkMetricsRegistry.newDeltaCounter("counters.reported");
        this.wfHistogramsReported = this.sdkMetricsRegistry.newDeltaCounter("wavefront_histograms.reported");
        this.histogramsReported = this.sdkMetricsRegistry.newDeltaCounter("histograms.reported");
        this.metersReported = this.sdkMetricsRegistry.newDeltaCounter("meters.reported");
        this.timersReported = this.sdkMetricsRegistry.newDeltaCounter("timers.reported");
        this.reportErrors = this.sdkMetricsRegistry.newDeltaCounter("errors");
    }

    private <T extends Metric> void tryRegister(MetricRegistry registry, String name, T metric) {
        try {
            registry.register(name, metric);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.INFO, e.getMessage());
        }
    }

    private void reportTimer(MetricName metricName, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.sendIfEnabled(MetricAttribute.MAX, metricName, this.scheduledReporter.convertDuration(snapshot.getMax()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN, metricName, this.scheduledReporter.convertDuration(snapshot.getMean()), timestamp);
        this.sendIfEnabled(MetricAttribute.MIN, metricName, this.scheduledReporter.convertDuration(snapshot.getMin()), timestamp);
        this.sendIfEnabled(MetricAttribute.STDDEV, metricName, this.scheduledReporter.convertDuration(snapshot.getStdDev()), timestamp);
        this.sendIfEnabled(MetricAttribute.P50, metricName, this.scheduledReporter.convertDuration(snapshot.getMedian()), timestamp);
        this.sendIfEnabled(MetricAttribute.P75, metricName, this.scheduledReporter.convertDuration(snapshot.get75thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P95, metricName, this.scheduledReporter.convertDuration(snapshot.get95thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P98, metricName, this.scheduledReporter.convertDuration(snapshot.get98thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P99, metricName, this.scheduledReporter.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P999, metricName, this.scheduledReporter.convertDuration(snapshot.get999thPercentile()), timestamp);
        this.reportMetered(metricName, timer, timestamp);
    }

    private void reportMetered(MetricName metricName, Metered meter, long timestamp) throws IOException {
        this.sendIfEnabled(MetricAttribute.COUNT, metricName, meter.getCount(), timestamp);
        this.sendIfEnabled(MetricAttribute.M1_RATE, metricName, this.scheduledReporter.convertRate(meter.getOneMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M5_RATE, metricName, this.scheduledReporter.convertRate(meter.getFiveMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M15_RATE, metricName, this.scheduledReporter.convertRate(meter.getFifteenMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN_RATE, metricName, this.scheduledReporter.convertRate(meter.getMeanRate()), timestamp);
    }

    private void reportHistogram(MetricName metricName, Histogram histogram, long timestamp) throws IOException {
        if (histogram instanceof WavefrontHistogram) {
            String histogramName = this.prefixAndSanitize(metricName.getKey());
            for (WavefrontHistogramImpl.Distribution distribution : ((WavefrontHistogram)histogram).flushDistributions()) {
                this.wavefrontSender.sendDistribution(histogramName, distribution.centroids, this.histogramGranularities, Long.valueOf(distribution.timestamp), this.source, this.getMetricTags(metricName));
            }
        } else {
            Snapshot snapshot = histogram.getSnapshot();
            this.sendIfEnabled(MetricAttribute.COUNT, metricName, histogram.getCount(), timestamp);
            this.sendIfEnabled(MetricAttribute.MAX, metricName, snapshot.getMax(), timestamp);
            this.sendIfEnabled(MetricAttribute.MEAN, metricName, snapshot.getMean(), timestamp);
            this.sendIfEnabled(MetricAttribute.MIN, metricName, snapshot.getMin(), timestamp);
            this.sendIfEnabled(MetricAttribute.STDDEV, metricName, snapshot.getStdDev(), timestamp);
            this.sendIfEnabled(MetricAttribute.P50, metricName, snapshot.getMedian(), timestamp);
            this.sendIfEnabled(MetricAttribute.P75, metricName, snapshot.get75thPercentile(), timestamp);
            this.sendIfEnabled(MetricAttribute.P95, metricName, snapshot.get95thPercentile(), timestamp);
            this.sendIfEnabled(MetricAttribute.P98, metricName, snapshot.get98thPercentile(), timestamp);
            this.sendIfEnabled(MetricAttribute.P99, metricName, snapshot.get99thPercentile(), timestamp);
            this.sendIfEnabled(MetricAttribute.P999, metricName, snapshot.get999thPercentile(), timestamp);
        }
    }

    private void reportCounter(MetricName metricName, Counter counter, long timestamp) throws IOException {
        if (counter instanceof DeltaCounter) {
            long count = counter.getCount();
            String name = "\u2206" + this.prefixAndSanitize(metricName.getKey().substring(1), "count");
            this.wavefrontSender.sendDeltaCounter(name, (double)count, Long.valueOf(timestamp), this.source, this.getMetricTags(metricName));
            counter.dec(count);
        } else {
            this.wavefrontSender.sendMetric(this.prefixAndSanitize(metricName.getKey(), "count"), (double)counter.getCount(), Long.valueOf(timestamp), this.source, this.getMetricTags(metricName));
        }
    }

    private void reportGauge(MetricName metricName, Gauge<Number> gauge, long timestamp) throws IOException {
        this.wavefrontSender.sendMetric(this.prefixAndSanitize(metricName.getKey()), gauge.getValue().doubleValue(), Long.valueOf(timestamp), this.source, this.getMetricTags(metricName));
    }

    private void sendIfEnabled(MetricAttribute type, MetricName metricName, double value, long timestamp) throws IOException {
        if (!this.scheduledReporter.getDisabledMetricAttributes().contains((Object)type)) {
            this.wavefrontSender.sendMetric(this.prefixAndSanitize(metricName.getKey(), type.getCode()), value, Long.valueOf(timestamp), this.source, this.getMetricTags(metricName));
        }
    }

    private Map<String, String> getMetricTags(MetricName metricName) {
        int tagCount = this.reporterPointTags.size() + metricName.getTags().size();
        if (tagCount == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> metricTags = new HashMap<String, String>();
        metricTags.putAll(metricName.getTags());
        this.reporterPointTags.forEach(metricTags::putIfAbsent);
        return metricTags;
    }

    private String prefixAndSanitize(String ... components) {
        return WavefrontInternalReporter.sanitize(MetricRegistry.name(this.prefix, components).getKey());
    }

    private static String sanitize(String name) {
        return SIMPLE_NAMES.matcher(name).replaceAll("_");
    }

    public void report() {
        this.scheduledReporter.report();
    }

    @Override
    public void start(long period, TimeUnit unit) {
        this.scheduledReporter.start(period, unit);
    }

    @Override
    public void stop() {
        this.scheduledReporter.stop();
        this.sdkMetricsRegistry.close();
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public Counter newCounter(MetricName metricName) {
        return this.internalRegistry.counter(metricName);
    }

    @Override
    public DeltaCounter newDeltaCounter(MetricName metricName) {
        return DeltaCounter.get(this.internalRegistry, metricName);
    }

    @Override
    public Gauge newGauge(MetricName metricName, MetricRegistry.MetricSupplier<Gauge> supplier) {
        return this.internalRegistry.gauge(metricName, supplier);
    }

    @Override
    public Histogram newHistogram(MetricName metricName) {
        return this.internalRegistry.histogram(metricName);
    }

    @Override
    public Timer newTimer(MetricName metricName) {
        return this.internalRegistry.timer(metricName);
    }

    @Override
    public Timer newTimer(MetricName metricName, SlidingTimeWindowArrayReservoir slidingTimeWindowArrayReservoir) {
        MetricRegistry.MetricSupplier<Timer> timerMetricSupplier = () -> new Timer(slidingTimeWindowArrayReservoir);
        return this.internalRegistry.timer(metricName, timerMetricSupplier);
    }

    @Override
    public Meter newMeter(MetricName metricName) {
        return this.internalRegistry.meter(metricName);
    }

    @Override
    public WavefrontHistogram newWavefrontHistogram(MetricName metricName) {
        return WavefrontHistogram.get(this.internalRegistry, metricName);
    }

    @Override
    public WavefrontHistogram newWavefrontHistogram(MetricName metricName, Supplier<Long> clock) {
        return WavefrontHistogram.get(this.internalRegistry, metricName, clock);
    }

    @Override
    public int getFailureCount() {
        return this.wavefrontSender.getFailureCount();
    }

    public static class Builder {
        private String prefix = null;
        private String source;
        private final Map<String, String> reporterPointTags;
        private final Set<HistogramGranularity> histogramGranularities;
        private boolean includeJvmMetrics = false;
        private Clock clock = Clock.defaultClock();
        private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("wavefront-internal-reporter").setDaemon(true));

        private static String getDefaultSource() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                return WavefrontInternalReporter.DEFAULT_SOURCE_WF_INTERNAL_REPORTER;
            }
        }

        public Builder() {
            this.source = Builder.getDefaultSource();
            this.reporterPointTags = new HashMap<String, String>();
            this.histogramGranularities = new HashSet<HistogramGranularity>();
        }

        public Builder withScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withReporterPointTags(Map<String, String> reporterPointTags) {
            this.reporterPointTags.putAll(reporterPointTags);
            return this;
        }

        public Builder withReporterPointTag(String tagKey, String tagVal) {
            this.reporterPointTags.put(tagKey, tagVal);
            return this;
        }

        public Builder reportMinuteDistribution() {
            this.histogramGranularities.add(HistogramGranularity.MINUTE);
            return this;
        }

        public Builder reportHourDistribution() {
            this.histogramGranularities.add(HistogramGranularity.HOUR);
            return this;
        }

        public Builder reportDayDistribution() {
            this.histogramGranularities.add(HistogramGranularity.DAY);
            return this;
        }

        public Builder includeJvmMetrics() {
            this.includeJvmMetrics = true;
            return this;
        }

        public WavefrontInternalReporter build(WavefrontSender wavefrontSender) {
            return new WavefrontInternalReporter(new MetricRegistry(), wavefrontSender, this.prefix, this.source, this.reporterPointTags, this.histogramGranularities, this.includeJvmMetrics, this.clock, this.scheduledExecutorService);
        }
    }
}

