/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal;

import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.java_sdk.com.google.common.annotations.VisibleForTesting;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpanDerivedMetricsUtils {
    public static final String TRACING_DERIVED_PREFIX = "tracing.derived";
    public static final String ERROR_SPAN_TAG_KEY = "error";
    public static final String ERROR_SPAN_TAG_VAL = "true";
    public static final String DEBUG_SPAN_TAG_KEY = "debug";
    public static final String DEBUG_SPAN_TAG_VAL = "true";
    private static final String INVOCATION_SUFFIX = ".invocation";
    private static final String ERROR_SUFFIX = ".error";
    private static final String DURATION_SUFFIX = ".duration.micros";
    private static final String TOTAL_TIME_SUFFIX = ".total_time.millis";
    private static final String OPERATION_NAME_TAG = "operationName";
    private static final String SPAN_KIND_KEY = "span.kind";
    private static final String HTTP_STATUS_KEY = "http.status_code";

    @Nonnull
    public static Pair<Map<String, String>, String> reportWavefrontGeneratedData(@Nonnull WavefrontInternalReporter wfInternalReporter, @Nonnull String operationName, @Nonnull String application, @Nonnull String service, String cluster, String shard, String source, String componentTagValue, boolean isError, long spanDurationMicros, Set<String> traceDerivedCustomTagKeys, List<Pair<String, String>> spanTags) {
        return SpanDerivedMetricsUtils.reportWavefrontGeneratedData(wfInternalReporter, operationName, application, service, cluster, shard, source, componentTagValue, isError, spanDurationMicros, traceDerivedCustomTagKeys, spanTags, true, System::currentTimeMillis);
    }

    @Nonnull
    public static Pair<Map<String, String>, String> reportWavefrontGeneratedData(@Nonnull WavefrontInternalReporter wfInternalReporter, @Nonnull String operationName, @Nonnull String application, @Nonnull String service, String cluster, String shard, String source, String componentTagValue, boolean isError, long spanDurationMicros, Set<String> traceDerivedCustomTagKeys, List<Pair<String, String>> spanTags, boolean isReportingDelta) {
        return SpanDerivedMetricsUtils.reportWavefrontGeneratedData(wfInternalReporter, operationName, application, service, cluster, shard, source, componentTagValue, isError, spanDurationMicros, traceDerivedCustomTagKeys, spanTags, isReportingDelta, System::currentTimeMillis);
    }

    @Nonnull
    @VisibleForTesting
    protected static Pair<Map<String, String>, String> reportWavefrontGeneratedData(@Nonnull WavefrontInternalReporter wfInternalReporter, String operationName, String application, String service, String cluster, String shard, String source, String componentTagValue, boolean isError, long spanDurationMicros, Set<String> traceDerivedCustomTagKeys, List<Pair<String, String>> spanTags, boolean isReportingDelta, Supplier<Long> clock) {
        HashMap<String, String> pointTags = new HashMap<String, String>();
        source = SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(source, "unknown_source");
        pointTags.put("application", SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(application, "unknown_application"));
        pointTags.put("service", SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(service, "unknown_service"));
        pointTags.put("cluster", SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(cluster, "none"));
        pointTags.put("shard", SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(shard, "none"));
        pointTags.put(OPERATION_NAME_TAG, SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(operationName, "unknown_operation"));
        pointTags.put("component", SpanDerivedMetricsUtils.getNonEmptyOrDefaultValue(componentTagValue, "none"));
        pointTags.put("source", source);
        boolean hasTraceDerivedCustomTagKeys = traceDerivedCustomTagKeys != null && traceDerivedCustomTagKeys.size() > 0;
        spanTags.forEach(tag -> {
            String tagKey = (String)tag._1;
            String tagValue = (String)tag._2;
            if (hasTraceDerivedCustomTagKeys && traceDerivedCustomTagKeys.contains(tagKey)) {
                pointTags.put(tagKey, tagValue);
            }
            if (tagKey.equalsIgnoreCase(HTTP_STATUS_KEY)) {
                pointTags.put(HTTP_STATUS_KEY, tagValue);
            }
        });
        pointTags.putIfAbsent(SPAN_KIND_KEY, "none");
        SpanDerivedMetricsUtils.incCounter(wfInternalReporter, new MetricName(Utils.sanitizeWithoutQuotes((String)(application + "." + service + "." + operationName + INVOCATION_SUFFIX)), pointTags), isReportingDelta);
        if (isError) {
            SpanDerivedMetricsUtils.incCounter(wfInternalReporter, new MetricName(Utils.sanitizeWithoutQuotes((String)(application + "." + service + "." + operationName + ERROR_SUFFIX)), pointTags), isReportingDelta);
        }
        if (isError) {
            HashMap<String, String> errorPointTags = new HashMap<String, String>(pointTags);
            errorPointTags.put(ERROR_SPAN_TAG_KEY, "true");
            wfInternalReporter.newWavefrontHistogram(new MetricName(Utils.sanitizeWithoutQuotes((String)(application + "." + service + "." + operationName + DURATION_SUFFIX)), errorPointTags), clock).update(spanDurationMicros);
        } else {
            wfInternalReporter.newWavefrontHistogram(new MetricName(Utils.sanitizeWithoutQuotes((String)(application + "." + service + "." + operationName + DURATION_SUFFIX)), pointTags), clock).update(spanDurationMicros);
        }
        SpanDerivedMetricsUtils.incCounter(wfInternalReporter, new MetricName(Utils.sanitizeWithoutQuotes((String)(application + "." + service + "." + operationName + TOTAL_TIME_SUFFIX)), pointTags), isReportingDelta, spanDurationMicros / 1000L);
        pointTags.remove(OPERATION_NAME_TAG);
        pointTags.remove("source");
        return new Pair(pointTags, (Object)source);
    }

    private static void incCounter(WavefrontInternalReporter wfInternalReporter, MetricName metric, boolean isReportingDelta) {
        SpanDerivedMetricsUtils.incCounter(wfInternalReporter, metric, isReportingDelta, 1L);
    }

    private static void incCounter(WavefrontInternalReporter wfInternalReporter, MetricName metric, boolean isReportingDelta, long n) {
        if (isReportingDelta) {
            wfInternalReporter.newDeltaCounter(metric).inc(n);
        } else {
            wfInternalReporter.newCounter(metric).inc(n);
        }
    }

    public static void reportHeartbeats(WavefrontSender wavefrontSender, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics) throws IOException {
        SpanDerivedMetricsUtils.reportHeartbeats(wavefrontSender, discoveredHeartbeatMetrics, "");
    }

    public static void reportHeartbeats(WavefrontSender wavefrontSender, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics, @Nonnull String secondaryComponent) throws IOException {
        if (wavefrontSender == null) {
            return;
        }
        for (Pair<Map<String, String>, String> key : discoveredHeartbeatMetrics) {
            HashMap<String, String> tags = new HashMap<String, String>((Map)key._1);
            String source = (String)key._2;
            wavefrontSender.sendMetric("~component.heartbeat", 1.0, Long.valueOf(System.currentTimeMillis()), source, tags);
            if (!secondaryComponent.trim().isEmpty()) {
                tags.put("component", secondaryComponent);
                wavefrontSender.sendMetric("~component.heartbeat", 1.0, Long.valueOf(System.currentTimeMillis()), source, tags);
            }
            discoveredHeartbeatMetrics.remove(key);
        }
    }

    private static String getNonEmptyOrDefaultValue(@Nullable String inputValue, String defaultValue) {
        if (inputValue == null || inputValue.trim().isEmpty()) {
            return defaultValue;
        }
        return inputValue;
    }
}

