/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing;

import com.wavefront.opentracing.Reference;
import com.wavefront.opentracing.WavefrontSpan;
import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.WavefrontTracer;
import com.wavefront.sdk.common.Pair;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WavefrontSpanBuilder
implements Tracer.SpanBuilder {
    private final WavefrontTracer tracer;
    private final String operationName;
    private List<Reference> parents = null;
    private List<Reference> follows = null;
    private long startTimeMicros;
    private boolean ignoreActiveSpan = false;
    private boolean useFullSpanId = true;
    private final List<Pair<String, String>> tags = new ArrayList<Pair<String, String>>();

    public WavefrontSpanBuilder(String operationName, WavefrontTracer tracer) {
        this.operationName = operationName;
        this.tracer = tracer;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parentContext) {
        return this.addReference("child_of", parentContext);
    }

    public Tracer.SpanBuilder asChildOf(Span parent) {
        return this.addReference("child_of", parent == null ? null : parent.context());
    }

    public Tracer.SpanBuilder addReference(String type, SpanContext spanContext) {
        if (!(spanContext instanceof WavefrontSpanContext) || !"child_of".equals(type) && !"follows_from".equals(type)) {
            return this;
        }
        Reference ref = new Reference((WavefrontSpanContext)spanContext, type);
        if ("child_of".equals(type)) {
            if (this.parents == null) {
                this.parents = new ArrayList<Reference>(1);
            }
            this.parents.add(ref);
        } else if ("follows_from".equals(type)) {
            if (this.follows == null) {
                this.follows = new ArrayList<Reference>(1);
            }
            this.follows.add(ref);
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        return this.setTagObject(key, value);
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        return this.setTagObject(key, value);
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        return this.setTagObject(key, value);
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        return this.setTagObject(tag.getKey(), value);
    }

    private Tracer.SpanBuilder setTagObject(String key, Object value) {
        if (key != null && !key.isEmpty() && value != null) {
            this.tags.add((Pair<String, String>)Pair.of((Object)key, (Object)value.toString()));
        }
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long startMicros) {
        this.startTimeMicros = startMicros;
        return this;
    }

    public Span start() {
        WavefrontSpanContext ctx;
        long startTimeNanos = 0L;
        if (this.startTimeMicros == 0L) {
            this.startTimeMicros = this.tracer.currentTimeMicros();
            startTimeNanos = System.nanoTime();
        }
        if (!(ctx = this.createSpanContext()).isSampled()) {
            boolean decision = this.tracer.sample(this.operationName, ctx.getTraceId().getLeastSignificantBits(), 0L);
            ctx = ctx.withSamplingDecision(decision);
        }
        return new WavefrontSpan(this.tracer, this.operationName, ctx, this.startTimeMicros, startTimeNanos, this.parents, this.follows, this.tags);
    }

    private WavefrontSpanContext createSpanContext() {
        UUID spanId = this.generateSpanId();
        WavefrontSpanContext traceCtx = this.traceAncestry();
        UUID traceId = traceCtx == null ? UUID.randomUUID() : traceCtx.getTraceId();
        Boolean sampling = traceCtx == null ? null : traceCtx.getSamplingDecision();
        return new WavefrontSpanContext(traceId, spanId, this.getBaggage(), sampling);
    }

    @Nullable
    private Map<String, String> getBaggage() {
        return this.addItems(this.follows, this.addItems(this.parents, null));
    }

    @Nullable
    private Map<String, String> addItems(List<Reference> references, @Nullable Map<String, String> baggage) {
        if (references != null && !references.isEmpty()) {
            for (Reference ref : references) {
                Map<String, String> refBaggage = ref.getSpanContext().getBaggage();
                if (refBaggage == null || refBaggage.isEmpty()) continue;
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.putAll(refBaggage);
            }
        }
        return baggage;
    }

    @Nullable
    private WavefrontSpanContext traceAncestry() {
        Span parentSpan;
        if (this.parents != null && !this.parents.isEmpty()) {
            return this.parents.get(0).getSpanContext();
        }
        if (this.follows != null && !this.follows.isEmpty()) {
            return this.follows.get(0).getSpanContext();
        }
        Span span = parentSpan = !this.ignoreActiveSpan ? this.tracer.activeSpan() : null;
        if (parentSpan != null) {
            this.asChildOf(parentSpan);
        }
        return parentSpan == null ? null : (WavefrontSpanContext)parentSpan.context();
    }

    private UUID generateSpanId() {
        long id;
        if (this.tracer.isUseSpanId128Bit()) {
            return UUID.randomUUID();
        }
        while ((id = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return new UUID(0L, id);
    }
}

