/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.propagation;

import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.propagation.Propagator;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class JaegerWavefrontPropagator
implements Propagator<TextMap> {
    private static final String BAGGAGE_PREFIX = "baggage-";
    private static final String TRACE_ID_KEY = "trace-id";
    private static final String PARENT_ID_KEY = "parent-id";
    private static final String SAMPLING_DECISION_KEY = "sampling-decision";
    private final String traceIdHeader;
    private final String baggagePrefix;

    private JaegerWavefrontPropagator(Builder builder) {
        this.traceIdHeader = builder.traceIdHeader;
        this.baggagePrefix = builder.baggagePrefix;
    }

    @Override
    @Nullable
    public WavefrontSpanContext extract(TextMap carrier) {
        UUID traceId = null;
        UUID spanId = null;
        String parentId = null;
        Boolean samplingDecision = null;
        HashMap<String, String> baggage = new HashMap<String, String>();
        for (Map.Entry entry : carrier) {
            String k = ((String)entry.getKey()).toLowerCase();
            if (k.equalsIgnoreCase(this.traceIdHeader)) {
                String[] traceData = this.contextFromTraceIdHeader((String)entry.getValue());
                if (traceData == null) continue;
                traceId = this.toUuid(traceData[0]);
                spanId = this.toUuid(traceData[1]);
                parentId = spanId.toString();
                samplingDecision = traceData[3].equals("1");
                continue;
            }
            if (!k.startsWith(this.baggagePrefix.toLowerCase())) continue;
            baggage.put(this.strippedPrefix((String)entry.getKey()), (String)entry.getValue());
        }
        if (traceId == null || spanId == null) {
            return null;
        }
        if (parentId.trim().length() > 0 && !"null".equals(parentId)) {
            baggage.put(PARENT_ID_KEY, parentId);
        }
        return new WavefrontSpanContext(traceId, spanId, baggage, samplingDecision);
    }

    @Override
    public void inject(WavefrontSpanContext spanContext, TextMap carrier) {
        carrier.put(this.traceIdHeader, this.contextToTraceIdHeader(spanContext));
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(this.baggagePrefix + entry.getKey(), entry.getValue());
        }
        if (spanContext.isSampled()) {
            carrier.put(SAMPLING_DECISION_KEY, spanContext.getSamplingDecision().toString());
        }
    }

    @Nullable
    private String[] contextFromTraceIdHeader(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        try {
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String[] toks = value.split(":");
        if (toks.length != 4) {
            return null;
        }
        if (toks[0] == null || toks[0].length() == 0) {
            return null;
        }
        return toks;
    }

    private String contextToTraceIdHeader(WavefrontSpanContext context) {
        BigInteger parentId;
        BigInteger traceId = this.uuidToBigInteger(context.getTraceId());
        BigInteger spanId = this.uuidToBigInteger(context.getSpanId());
        try {
            parentId = this.uuidToBigInteger(UUID.fromString(context.getBaggageItem(PARENT_ID_KEY)));
        }
        catch (Exception e) {
            parentId = BigInteger.ZERO;
        }
        Boolean samplingDecision = context.getSamplingDecision();
        if (samplingDecision == null) {
            samplingDecision = false;
        }
        StringBuilder outCtx = new StringBuilder();
        outCtx.append(traceId.toString(16)).append(":").append(spanId.toString(16)).append(":").append(parentId.toString(16)).append(":").append(samplingDecision != false ? "1" : "0");
        return outCtx.toString();
    }

    private String strippedPrefix(String val) {
        return val.substring(this.baggagePrefix.length());
    }

    BigInteger uuidToBigInteger(UUID id) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(id.getMostSignificantBits());
        bb.putLong(id.getLeastSignificantBits());
        return new BigInteger(1, bb.array());
    }

    private static long high(String hexString) {
        if (hexString.length() <= 16) {
            return 0L;
        }
        int highLength = hexString.length() - 16;
        String highString = hexString.substring(0, highLength);
        return new BigInteger(highString, 16).longValue();
    }

    UUID toUuid(String id) {
        long idLow = new BigInteger(id, 16).longValue();
        long idHigh = JaegerWavefrontPropagator.high(id);
        return new UUID(idHigh, idLow);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String traceIdHeader = "trace-id";
        private String baggagePrefix = "baggage-";

        public Builder withTraceIdHeader(String traceIdHeader) {
            this.traceIdHeader = traceIdHeader;
            return this;
        }

        public Builder withBaggagePrefix(String baggagePrefix) {
            this.baggagePrefix = baggagePrefix;
            return this;
        }

        public JaegerWavefrontPropagator build() {
            return new JaegerWavefrontPropagator(this);
        }
    }
}

