/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.propagation;

import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.propagation.Propagator;
import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class TextMapPropagator
implements Propagator<TextMap> {
    private static final String BAGGAGE_PREFIX = "wf-ot-";
    private static final String TRACE_ID = "wf-ot-traceid";
    private static final String SPAN_ID = "wf-ot-spanid";
    private static final String SAMPLE = "wf-ot-sample";

    @Override
    public void inject(WavefrontSpanContext spanContext, TextMap carrier) {
        carrier.put(TRACE_ID, spanContext.getTraceId().toString());
        carrier.put(SPAN_ID, spanContext.getSpanId().toString());
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(BAGGAGE_PREFIX + entry.getKey(), entry.getValue());
        }
        if (spanContext.isSampled()) {
            carrier.put(SAMPLE, spanContext.getSamplingDecision().toString());
        }
    }

    @Override
    @Nullable
    public WavefrontSpanContext extract(TextMap carrier) {
        UUID traceId = null;
        UUID spanId = null;
        HashMap baggage = null;
        Boolean sampling = null;
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            if (TRACE_ID.equals(key)) {
                traceId = UUID.fromString((String)entry.getValue());
                continue;
            }
            if (SPAN_ID.equals(key)) {
                spanId = UUID.fromString((String)entry.getValue());
                continue;
            }
            if (SAMPLE.equals(key)) {
                sampling = Boolean.valueOf((String)entry.getValue());
                continue;
            }
            if (!key.startsWith(BAGGAGE_PREFIX)) continue;
            if (baggage == null) {
                baggage = new HashMap();
            }
            baggage.put(TextMapPropagator.stripPrefix(key), entry.getValue());
        }
        if (traceId == null || spanId == null) {
            return null;
        }
        return new WavefrontSpanContext(traceId, spanId, baggage, sampling);
    }

    private static String stripPrefix(String key) {
        return key.substring(BAGGAGE_PREFIX.length());
    }
}

