/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.reporting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wavefront.opentracing.Reference;
import com.wavefront.opentracing.WavefrontSpan;
import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.entities.tracing.SpanLog;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class ConsoleReporter
implements Reporter {
    private final String source;

    public ConsoleReporter(String source) {
        this.source = source;
    }

    @Override
    public void report(WavefrontSpan span) {
        WavefrontSpanContext ctx = span.context();
        List<Reference> parentRefs = span.getParents();
        List<Reference> followsRefs = span.getFollows();
        List parents = parentRefs == null ? null : parentRefs.stream().map(Reference::getSpanContext).map(WavefrontSpanContext::getSpanId).collect(Collectors.toList());
        List follows = followsRefs == null ? null : followsRefs.stream().map(Reference::getSpanContext).map(WavefrontSpanContext::getSpanId).collect(Collectors.toList());
        List<SpanLog> spanLogs = span.getSpanLogs();
        String spanLine = Utils.tracingSpanToLineData((String)span.getOperationName(), (long)span.getStartTimeMicros(), (long)span.getDurationMicroseconds(), (String)this.source, (UUID)ctx.getTraceId(), (UUID)ctx.getSpanId(), parents, follows, span.getTagsAsList(), spanLogs, (String)"unknown");
        System.out.println("Finished span: sampling=" + ctx.getSamplingDecision() + " " + spanLine);
        if (!spanLogs.isEmpty()) {
            try {
                System.out.println("SpanLogs: " + Utils.spanLogsToLineData((UUID)ctx.getTraceId(), (UUID)ctx.getSpanId(), spanLogs));
            }
            catch (JsonProcessingException e) {
                System.out.println("Error processing the span logs " + (Object)((Object)e));
            }
        }
    }

    @Override
    public int getFailureCount() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

