/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.reporting;

import com.wavefront.opentracing.WavefrontSpan;
import com.wavefront.opentracing.reporting.Reporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompositeReporter
implements Reporter {
    private final List<Reporter> reporters = new ArrayList<Reporter>();

    public CompositeReporter(Reporter ... reporters) {
        for (Reporter reporter : reporters) {
            this.reporters.add(reporter);
        }
    }

    public List<Reporter> getReporters() {
        return new ArrayList<Reporter>(this.reporters);
    }

    @Override
    public void report(WavefrontSpan span) throws IOException {
        for (Reporter reporter : this.reporters) {
            reporter.report(span);
        }
    }

    @Override
    public int getFailureCount() {
        int result = 0;
        for (Reporter reporter : this.reporters) {
            result += reporter.getFailureCount();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        for (Reporter reporter : this.reporters) {
            reporter.close();
        }
    }

    @Override
    public void flush() {
        for (Reporter reporter : this.reporters) {
            reporter.flush();
        }
    }
}

