/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.reporting;

import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.DeltaCounter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.opentracing.Reference;
import com.wavefront.opentracing.WavefrontSpan;
import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.sdk.common.WavefrontSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class WavefrontSpanReporter
implements Reporter,
Runnable {
    private static final Logger logger = Logger.getLogger(WavefrontSpanReporter.class.getName());
    private final WavefrontSender wavefrontSender;
    private final String source;
    private final LinkedBlockingQueue<WavefrontSpan> spanBuffer;
    private final Thread sendingThread;
    private final Random random;
    private final float logPercent;
    private final boolean reportSpanLogs;
    private volatile WavefrontInternalReporter metricsReporter;
    private DeltaCounter spansDropped;
    private DeltaCounter spansReceived;
    private DeltaCounter reportErrors;
    private volatile boolean stop = false;

    private WavefrontSpanReporter(WavefrontSender wavefrontSender, String source, int maxQueueSize, float logPercent, boolean reportSpanLogs) {
        this.wavefrontSender = wavefrontSender;
        this.source = source;
        this.spanBuffer = new LinkedBlockingQueue(maxQueueSize);
        this.random = new Random();
        this.logPercent = logPercent;
        this.reportSpanLogs = reportSpanLogs;
        this.sendingThread = new Thread((Runnable)this, "wavefrontSpanReporter");
        this.sendingThread.setDaemon(true);
        this.sendingThread.start();
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                WavefrontSpan span = this.spanBuffer.take();
                this.send(span);
            }
            catch (InterruptedException ex) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("reporting thread interrupted");
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "Error processing buffer", ex);
            }
        }
    }

    @Override
    public void report(WavefrontSpan span) {
        if (this.metricsReporter != null) {
            this.spansReceived.inc();
        }
        if (!this.spanBuffer.offer(span)) {
            if (this.metricsReporter != null) {
                this.spansDropped.inc();
            }
            if (this.loggingAllowed()) {
                logger.warning("Buffer full, dropping span: " + span);
                if (this.metricsReporter != null) {
                    logger.warning("Total spans dropped: " + this.spansDropped.getCount());
                }
            }
        }
    }

    private void send(WavefrontSpan span) {
        block3: {
            try {
                WavefrontSpanContext ctx = span.context();
                List<Reference> parentRefs = span.getParents();
                List<Reference> followsRefs = span.getFollows();
                List parents = parentRefs == null ? null : parentRefs.stream().map(Reference::getSpanContext).map(WavefrontSpanContext::getSpanId).collect(Collectors.toList());
                List follows = followsRefs == null ? null : followsRefs.stream().map(Reference::getSpanContext).map(WavefrontSpanContext::getSpanId).collect(Collectors.toList());
                this.wavefrontSender.sendSpan(span.getOperationName(), span.getStartTimeMicros() / 1000L, span.getDurationMicroseconds() / 1000L, this.source, ctx.getTraceId(), ctx.getSpanId(), parents, follows, span.getTagsAsList(), this.reportSpanLogs ? span.getSpanLogs() : null);
            }
            catch (IOException e) {
                if (this.loggingAllowed()) {
                    logger.log(Level.WARNING, "error reporting span: " + span, e);
                }
                if (this.metricsReporter == null) break block3;
                this.reportErrors.inc();
                this.spansDropped.inc();
            }
        }
    }

    private boolean loggingAllowed() {
        return this.random.nextFloat() <= this.logPercent;
    }

    public String getSource() {
        return this.source;
    }

    public WavefrontSender getWavefrontSender() {
        return this.wavefrontSender;
    }

    @Override
    public int getFailureCount() {
        return this.wavefrontSender.getFailureCount();
    }

    public void setMetricsReporter(WavefrontInternalReporter metricsReporter) {
        this.metricsReporter = metricsReporter;
        metricsReporter.newGauge(new MetricName("reporter.queue.size", Collections.emptyMap()), () -> () -> (double)this.spanBuffer.size());
        metricsReporter.newGauge(new MetricName("reporter.queue.remaining_capacity", Collections.emptyMap()), () -> () -> (double)this.spanBuffer.remainingCapacity());
        this.spansReceived = metricsReporter.newDeltaCounter(new MetricName("reporter.spans.received", Collections.emptyMap()));
        this.spansDropped = metricsReporter.newDeltaCounter(new MetricName("reporter.spans.dropped", Collections.emptyMap()));
        this.reportErrors = metricsReporter.newDeltaCounter(new MetricName("reporter.errors", Collections.emptyMap()));
    }

    @Override
    public void close() throws IOException {
        this.stop = true;
        try {
            this.sendingThread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.wavefrontSender.close();
    }

    @Override
    public void flush() {
        try {
            this.wavefrontSender.flush();
        }
        catch (IOException e) {
            logger.warning("WavefrontSender flush() failed.");
        }
    }

    public static final class Builder {
        private String source = Builder.getDefaultSource();
        private int maxQueueSize = 50000;
        private float logPercent = 0.1f;
        private boolean reportSpanLogs = true;

        private static String getDefaultSource() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                return "wavefront-tracer";
            }
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withMaxQueueSize(int maxQueueSize) {
            if (maxQueueSize <= 0) {
                throw new IllegalArgumentException("invalid max queue size");
            }
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder withLoggingPercent(float percent) {
            if ((double)percent < 0.0 || (double)percent > 1.0) {
                throw new IllegalArgumentException("invalid logging percent");
            }
            this.logPercent = percent;
            return this;
        }

        public Builder disableSpanLogReporting() {
            this.reportSpanLogs = false;
            return this;
        }

        public WavefrontSpanReporter build(WavefrontSender wavefrontSender) {
            return new WavefrontSpanReporter(wavefrontSender, this.source, this.maxQueueSize, this.logPercent, this.reportSpanLogs);
        }
    }
}

