/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.sdk.appagent.jvm.reporter.WavefrontJvmReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={WavefrontSender.class})
class WavefrontMetricsConfiguration {
    WavefrontMetricsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"wavefront.metrics.extract-jvm-metrics"}, matchIfMissing=true)
    WavefrontJvmReporter wavefrontJvmReporter(WavefrontSender wavefrontSender, ApplicationTags applicationTags, WavefrontConfig wavefrontConfig) {
        WavefrontJvmReporter reporter = new WavefrontJvmReporter.Builder(applicationTags).withSource(wavefrontConfig.source()).build(wavefrontSender);
        reporter.start();
        return reporter;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WavefrontMeterRegistry.class, MeterRegistryCustomizer.class})
    static class MicrometerConfiguration {
        MicrometerConfiguration() {
        }

        @Bean
        MeterRegistryCustomizer<WavefrontMeterRegistry> wavefrontTagsMeterRegistryCustomizer(ObjectProvider<ApplicationTags> applicationTags) {
            return registry -> applicationTags.ifUnique(appTags -> registry.config().commonTags(this.createTagsFrom((ApplicationTags)appTags)));
        }

        private Iterable<Tag> createTagsFrom(ApplicationTags applicationTags) {
            HashMap tags = new HashMap();
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from(() -> ((ApplicationTags)applicationTags).getApplication()).to(application -> tags.put("application", application));
            mapper.from(() -> ((ApplicationTags)applicationTags).getService()).to(service -> tags.put("service", service));
            mapper.from(() -> ((ApplicationTags)applicationTags).getCluster()).to(cluster -> tags.put("cluster", cluster));
            mapper.from(() -> ((ApplicationTags)applicationTags).getShard()).to(shard -> tags.put("shard", shard));
            if (applicationTags.getCustomTags() != null) {
                tags.putAll(applicationTags.getCustomTags());
            }
            return Tags.of((Iterable)tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()));
        }
    }
}

