/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.autoconfigure.ApplicationTagsBuilderCustomizer;
import com.wavefront.spring.autoconfigure.ApplicationTagsFactory;
import com.wavefront.spring.autoconfigure.WavefrontMetricsConfiguration;
import com.wavefront.spring.autoconfigure.WavefrontProperties;
import com.wavefront.spring.autoconfigure.WavefrontTracingConfiguration;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront.WavefrontMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApplicationTags.class})
@EnableConfigurationProperties(value={WavefrontProperties.class})
@AutoConfigureAfter(value={WavefrontMetricsExportAutoConfiguration.class})
@Import(value={WavefrontMetricsConfiguration.class, WavefrontTracingConfiguration.class})
public class WavefrontAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationTags wavefrontApplicationTags(Environment environment, WavefrontProperties properties, ObjectProvider<ApplicationTagsBuilderCustomizer> customizers) {
        return new ApplicationTagsFactory(customizers.orderedStream().collect(Collectors.toList())).createFromProperties(environment, properties);
    }
}

