/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.spring.autoconfigure.WavefrontProperties;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.util.StringUtils;

public final class WavefrontSleuthSpanHandler
implements Runnable,
Closeable {
    private static final Log LOG = LogFactory.getLog(WavefrontSleuthSpanHandler.class);
    private static final String DEFAULT_SPAN_NAME = "defaultOperation";
    private static final String DEFAULT_SOURCE = "wavefront-spring-boot";
    private static final String WAVEFRONT_GENERATED_COMPONENT = "wavefront-generated";
    private static final int LONG_BYTES = 8;
    private static final int BYTE_BASE16 = 2;
    private static final int LONG_BASE16 = 16;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final byte[] DECODING = WavefrontSleuthSpanHandler.buildDecodingArray();
    final LinkedBlockingQueue<Pair<TraceContext, FinishedSpan>> spanBuffer;
    final WavefrontSender wavefrontSender;
    final WavefrontInternalReporter wfInternalReporter;
    final Set<String> traceDerivedCustomTagKeys;
    final Counter spansDropped;
    final Counter spansReceived;
    final Counter reportErrors;
    final Thread sendingThread;
    private volatile boolean stop = false;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    private final ScheduledExecutorService heartbeatMetricsScheduledExecutorService;
    final String source;
    final List<Pair<String, String>> defaultTags;
    final Set<String> defaultTagKeys;
    final ApplicationTags applicationTags;

    WavefrontSleuthSpanHandler(int maxQueueSize, WavefrontSender wavefrontSender, MeterRegistry meterRegistry, String source, ApplicationTags applicationTags, WavefrontProperties wavefrontProperties) {
        this.wavefrontSender = wavefrontSender;
        this.applicationTags = applicationTags;
        this.discoveredHeartbeatMetrics = ConcurrentHashMap.newKeySet();
        this.heartbeatMetricsScheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("sleuth-heart-beater").setDaemon(true));
        this.heartbeatMetricsScheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)wavefrontSender, this.discoveredHeartbeatMetrics, (String)WAVEFRONT_GENERATED_COMPONENT);
            }
            catch (IOException e) {
                LOG.warn((Object)"Cannot report heartbeat metric to wavefront");
            }
        }, 1L, 60L, TimeUnit.SECONDS);
        this.traceDerivedCustomTagKeys = new HashSet<String>(wavefrontProperties.getTracing().getRedMetricsCustomTagKeys());
        this.wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource(DEFAULT_SOURCE).reportMinuteDistribution().build(wavefrontSender);
        this.wfInternalReporter.start(1L, TimeUnit.MINUTES);
        this.source = source;
        this.defaultTags = WavefrontSleuthSpanHandler.createDefaultTags(applicationTags);
        this.defaultTagKeys = this.defaultTags.stream().map(p -> (String)p._1).collect(Collectors.toSet());
        this.defaultTagKeys.add("source");
        this.spanBuffer = new LinkedBlockingQueue(maxQueueSize);
        meterRegistry.gauge("reporter.queue.size", this.spanBuffer, sb -> sb.size());
        meterRegistry.gauge("reporter.queue.remaining_capacity", this.spanBuffer, sb -> sb.remainingCapacity());
        this.spansReceived = meterRegistry.counter("reporter.spans.received", new String[0]);
        this.spansDropped = meterRegistry.counter("reporter.spans.dropped", new String[0]);
        this.reportErrors = meterRegistry.counter("reporter.errors", new String[0]);
        this.sendingThread = new Thread((Runnable)this, "wavefrontSpanReporter");
        this.sendingThread.setDaemon(true);
        this.sendingThread.start();
    }

    public boolean end(TraceContext context, FinishedSpan span) {
        this.spansReceived.increment();
        if (!this.spanBuffer.offer((Pair<TraceContext, FinishedSpan>)Pair.of((Object)context, (Object)span))) {
            this.spansDropped.increment();
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Buffer full, dropping span: " + span));
                LOG.warn((Object)("Total spans dropped: " + this.spansDropped.count()));
            }
        }
        return true;
    }

    List<Pair<String, String>> getDefaultTags() {
        return Collections.unmodifiableList(this.defaultTags);
    }

    private String padLeftWithZeros(String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = string.length(); i < length; ++i) {
            sb.append('0');
        }
        return sb.append(string).toString();
    }

    private void send(TraceContext context, FinishedSpan span) {
        block8: {
            TagList tags;
            long durationMicros;
            String name;
            block7: {
                String traceIdString = this.padLeftWithZeros(context.traceId(), 32);
                String traceIdHigh = traceIdString.substring(0, traceIdString.length() / 2);
                String traceIdLow = traceIdString.substring(traceIdString.length() / 2);
                UUID traceId = new UUID(WavefrontSleuthSpanHandler.longFromBase16String(traceIdHigh), WavefrontSleuthSpanHandler.longFromBase16String(traceIdLow));
                UUID spanId = new UUID(0L, WavefrontSleuthSpanHandler.longFromBase16String(context.spanId()));
                List<UUID> parents = null;
                String parentId = context.parentId();
                if (StringUtils.hasText((String)parentId) && WavefrontSleuthSpanHandler.longFromBase16String(parentId) != 0L) {
                    parents = Collections.singletonList(new UUID(0L, WavefrontSleuthSpanHandler.longFromBase16String(parentId)));
                }
                List followsFrom = null;
                name = span.getName();
                if (name == null) {
                    name = DEFAULT_SPAN_NAME;
                }
                long startMillis = span.getStartTimestamp() / 1000L;
                long finishMillis = span.getEndTimestamp() / 1000L;
                long durationMillis = startMillis != 0L && finishMillis != 0L ? Math.max(finishMillis - startMillis, 1L) : 0L;
                durationMicros = span.getStartTimestamp() != 0L && span.getEndTimestamp() != 0L ? span.getEndTimestamp() - span.getStartTimestamp() : 0L;
                List<SpanLog> spanLogs = WavefrontSleuthSpanHandler.convertAnnotationsToSpanLogs(span);
                tags = new TagList(this.defaultTagKeys, this.defaultTags, span);
                try {
                    this.wavefrontSender.sendSpan(name, startMillis, durationMillis, this.source, traceId, spanId, parents, followsFrom, (List)tags, spanLogs);
                }
                catch (IOException | RuntimeException t) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("error sending span " + context), (Throwable)t);
                }
            }
            if (this.wfInternalReporter != null) {
                try {
                    this.discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)this.wfInternalReporter, (String)name, (String)this.applicationTags.getApplication(), (String)this.applicationTags.getService(), (String)(this.applicationTags.getCluster() == null ? "none" : this.applicationTags.getCluster()), (String)(this.applicationTags.getShard() == null ? "none" : this.applicationTags.getShard()), (String)this.source, (String)tags.componentTagValue, (boolean)tags.isError, (long)durationMicros, this.traceDerivedCustomTagKeys, (List)tags));
                }
                catch (RuntimeException t) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)("error sending span RED metrics " + context), (Throwable)t);
                }
            }
        }
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    private static long longFromBase16String(CharSequence chars) {
        int offset = 0;
        return ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)WavefrontSleuthSpanHandler.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    private static byte decodeByte(char hi, char lo) {
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    static List<SpanLog> convertAnnotationsToSpanLogs(FinishedSpan span) {
        return span.getEvents().stream().map(entry -> new SpanLog(((Long)entry.getKey()).longValue(), Collections.singletonMap("annotation", entry.getValue()))).collect(Collectors.toList());
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Pair<TraceContext, FinishedSpan> contextAndSpan = this.spanBuffer.take();
                this.send((TraceContext)contextAndSpan._1, (FinishedSpan)contextAndSpan._2);
            }
            catch (InterruptedException ex) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)"reporting thread interrupted");
            }
            catch (Throwable ex) {
                LOG.warn((Object)"Error processing buffer", ex);
            }
        }
    }

    @Override
    public void close() {
        this.stop = true;
        try {
            this.sendingThread.join(5000L);
            this.heartbeatMetricsScheduledExecutorService.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static List<Pair<String, String>> createDefaultTags(ApplicationTags applicationTags) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        result.add(Pair.of((Object)"application", (Object)applicationTags.getApplication()));
        result.add(Pair.of((Object)"service", (Object)applicationTags.getService()));
        result.add(Pair.of((Object)"cluster", (Object)(applicationTags.getCluster() == null ? "none" : applicationTags.getCluster())));
        result.add(Pair.of((Object)"shard", (Object)(applicationTags.getShard() == null ? "none" : applicationTags.getShard())));
        if (applicationTags.getCustomTags() != null) {
            applicationTags.getCustomTags().forEach((k, v) -> result.add(Pair.of((Object)k, (Object)v)));
        }
        return result;
    }

    static final class TagList
    extends ArrayList<Pair<String, String>> {
        String componentTagValue = "none";
        boolean isError;

        TagList(Set<String> defaultTagKeys, List<Pair<String, String>> defaultTags, FinishedSpan span) {
            super(defaultTags.size() + span.getTags().size());
            boolean debug = false;
            boolean hasAnnotations = span.getEvents().size() > 0;
            this.isError = span.getError() != null;
            this.addAll(defaultTags);
            for (Map.Entry tag : span.getTags().entrySet()) {
                String lowerCaseKey = ((String)tag.getKey()).toLowerCase(Locale.ROOT);
                if (lowerCaseKey.equals("error")) {
                    this.isError = true;
                    continue;
                }
                if (((String)tag.getValue()).isEmpty() || defaultTagKeys.contains(lowerCaseKey)) continue;
                if (lowerCaseKey.equals("debug")) {
                    debug = true;
                    continue;
                }
                if (lowerCaseKey.equals("component")) {
                    this.componentTagValue = (String)tag.getValue();
                }
                this.add(Pair.of(tag.getKey(), tag.getValue()));
            }
            if (this.isError) {
                this.add(Pair.of((Object)"error", (Object)"true"));
            }
            if (debug) {
                this.add(Pair.of((Object)"debug", (Object)"true"));
            }
            if (span.getKind() != null) {
                String kind = span.getKind().toString().toLowerCase();
                this.add(Pair.of((Object)"span.kind", (Object)kind));
                if (hasAnnotations) {
                    this.add(Pair.of((Object)"_spanSecondaryId", (Object)kind));
                }
            }
            if (hasAnnotations) {
                this.add(Pair.of((Object)"_spanLogs", (Object)"true"));
            }
            if (span.getLocalIp() != null) {
                this.add(Pair.of((Object)"ipv4", (Object)span.getLocalIp()));
            }
        }
    }
}

