/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.autoconfigure.ApplicationTagsBuilderCustomizer;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ApplicationTagsFactory {
    private static final String DEFAULT_APPLICATION_NAME = "unnamed_application";
    private static final String DEFAULT_SERVICE_NAME = "unnamed_service";
    private static final String PREFIX = "management.wavefront.application.";
    private final List<ApplicationTagsBuilderCustomizer> customizers;

    public ApplicationTagsFactory(List<ApplicationTagsBuilderCustomizer> customizers) {
        this.customizers = customizers != null ? customizers : Collections.emptyList();
    }

    public ApplicationTagsFactory() {
        this(null);
    }

    public ApplicationTags createFromEnvironment(Environment environment) {
        String name = this.getValue(environment, "name", () -> DEFAULT_APPLICATION_NAME);
        String service = this.getValue(environment, "service-name", () -> this.defaultServiceName(environment));
        return this.customize(new ApplicationTags.Builder(name, service).cluster(this.getValue(environment, "cluster-name", () -> null)).shard(this.getValue(environment, "shard-name", () -> null))).build();
    }

    private String defaultServiceName(Environment environment) {
        String applicationName = environment.getProperty("spring.application.name");
        return StringUtils.hasText((String)applicationName) ? applicationName : DEFAULT_SERVICE_NAME;
    }

    private ApplicationTags.Builder customize(ApplicationTags.Builder builder) {
        this.customizers.forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private String getValue(Environment environment, String name, Supplier<String> fallback) {
        String value = environment.getProperty(PREFIX + name);
        return value != null ? value : fallback.get();
    }
}

