/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.classloader;

import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.TypeConversionUtils;
import java.io.InputStream;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static Class<?> loadClass(String className) {
        return ClassLoaderUtils.loadClass(className, ClassLoaderUtils.getClassLoader());
    }

    public static Class<?> loadClass(String className, boolean initialize) {
        return ClassLoaderUtils.loadClass(className, initialize, ClassLoaderUtils.getClassLoader());
    }

    public static Class<?> loadClass(String className, ClassLoader loader) {
        return ClassLoaderUtils.loadClass(className, true, loader);
    }

    public static Class<?> loadClass(String className, boolean initialize, ClassLoader loader) {
        try {
            Class<?> rtn = TypeConversionUtils.primitiveForName(className);
            if (rtn == null) {
                rtn = Class.forName(className, initialize, loader);
            }
            return rtn;
        }
        catch (ClassNotFoundException ex) {
            Object s = ex.getMessage();
            if (s == null || ((String)s).equals("")) {
                s = "Cannot find class " + className;
            }
            throw new WMRuntimeException((String)s, (Throwable)ex);
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static InputStream getResourceAsStream(String path) {
        return ClassLoaderUtils.getClassLoader().getResourceAsStream(path);
    }
}

