/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.classloader;

import com.wavemaker.commons.classloader.WMCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceClassLoaderUtils.class);

    private ResourceClassLoaderUtils() {
    }

    public static <V> V runInClassLoaderContext(WMCallable<V> executable, ClassLoader cl) {
        return ResourceClassLoaderUtils.runInClassLoaderContext(executable, null, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runInClassLoaderContext(WMCallable<V> executable, Runnable finalizerTask, ClassLoader cl) {
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            V v = executable.call();
            return v;
        }
        finally {
            try {
                if (finalizerTask != null) {
                    finalizerTask.run();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to execute finalizer task", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(c);
            }
        }
    }
}

