/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.i18n;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.i18n.LocaleMessageProvider;
import com.wavemaker.commons.json.JSONUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class LocaleMessageProviderImpl
implements LocaleMessageProvider {
    private static final String CLASSPATH_MESSAGE_RESOURCE_PATH = "classpath*:i18n/wm";
    private LinkedHashSet<String> supportedLocales = new LinkedHashSet();
    private String defaultLocale = "en";
    private Cache<String, Map<String, String>> messages = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private ResourcePatternResolver resourcePatternResolver;
    private List<String> locationPatterns;
    private static final Logger logger = LoggerFactory.getLogger(LocaleMessageProviderImpl.class);

    public LocaleMessageProviderImpl() {
        this(Arrays.asList(CLASSPATH_MESSAGE_RESOURCE_PATH), (ResourcePatternResolver)new PathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader(LocaleMessageProviderImpl.class.getClassLoader())));
    }

    public LocaleMessageProviderImpl(List<String> locationPatterns, ResourcePatternResolver resourcePatternResolver) {
        this.locationPatterns = locationPatterns;
        this.resourcePatternResolver = resourcePatternResolver;
        this.init();
    }

    private synchronized void init() {
        List<Resource> resourceList = this.getResourceList("*.json");
        for (Resource resource : resourceList) {
            String locale = FilenameUtils.removeExtension((String)resource.getFilename());
            this.supportedLocales.add(locale);
        }
        if (!this.supportedLocales.contains(this.defaultLocale)) {
            if (this.supportedLocales.isEmpty()) {
                throw new WMRuntimeException("No locales available in the project");
            }
            String previousDefaultLocale = this.defaultLocale;
            this.defaultLocale = (String)this.supportedLocales.iterator().next();
            logger.warn("Default locale file for locale {} not found, using {} as the default locale", (Object)previousDefaultLocale, (Object)this.defaultLocale);
        }
    }

    @Override
    public String getLocaleMessage(String[] locales, MessageResource messageResource, String defaultMessage) {
        String localMessage = this.getLocaleMessage(locales, messageResource);
        if (localMessage != null) {
            return localMessage;
        }
        logger.warn("message for {} not found and default message is {}", (Object)messageResource.getMessageKey(), (Object)defaultMessage);
        return defaultMessage;
    }

    @Override
    public String getLocaleMessage(String[] locales, MessageResource messageResource, String defaultMessage, Object[] args) {
        String localeMessage = this.getLocaleMessage(locales, messageResource);
        if (localeMessage != null) {
            return MessageFormat.format(localeMessage, args);
        }
        logger.warn("message for {} not found, its args are {} and default message is {}", new Object[]{messageResource.getMessageKey(), args, defaultMessage});
        return defaultMessage;
    }

    private String getLocaleMessage(String[] locales, MessageResource messageResource) {
        Map<String, String> localeMessages = this.getLocaleMessages(locales);
        return localeMessages.get(messageResource.getMessageKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getLocaleMessages(String ... locales) {
        for (String locale : locales) {
            if (!this.supportedLocales.contains(locale)) continue;
            Map<String, String> existingMessages = (Map<String, String>)this.messages.getIfPresent((Object)locale);
            if (existingMessages == null) {
                Cache<String, Map<String, String>> cache = this.messages;
                synchronized (cache) {
                    existingMessages = (Map)this.messages.getIfPresent((Object)locale);
                    if (existingMessages == null) {
                        existingMessages = this.loadLocaleMessages(locale);
                        this.messages.put((Object)locale, existingMessages);
                    }
                }
            }
            return existingMessages;
        }
        return this.getLocaleMessages(this.defaultLocale);
    }

    protected Map<String, String> loadLocaleMessages(String locale) {
        HashMap<String, String> existingMessages = new HashMap<String, String>();
        try {
            List<Resource> resourceList = this.getResourceList(locale + ".json");
            for (Resource resource : resourceList) {
                Map<String, String> localeMessages = JSONUtils.toObject(resource.getInputStream(), new TypeReference<Map<String, String>>(){});
                existingMessages.putAll(localeMessages);
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException("Failed to read locale resources for locale " + locale, (Throwable)e);
        }
        return existingMessages;
    }

    protected Resource[] getResources(String locationPattern, String resourcePattern) {
        try {
            return this.resourcePatternResolver.getResources(locationPattern + "/" + resourcePattern);
        }
        catch (IOException e) {
            throw new WMRuntimeException("Failed to read locale files", (Throwable)e);
        }
    }

    private List<Resource> getResourceList(String resourcePattern) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String locationPattern : this.locationPatterns) {
            resourceList.addAll(Arrays.asList(this.getResources(locationPattern, resourcePattern)));
        }
        return resourceList;
    }
}

