/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.FileContent;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileContent
implements FileContent {
    @Override
    public Reader asReader() {
        return new InputStreamReader(this.asInputStream(), StandardCharsets.UTF_8);
    }

    @Override
    public String asString() {
        Reader reader = null;
        try {
            reader = this.asReader();
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(reader);
        }
    }

    @Override
    public byte[] asBytes() {
        InputStream inputStream = null;
        try {
            inputStream = this.asInputStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    @Override
    public void copyTo(OutputStream outputStream) {
        InputStream inputStream = null;
        try {
            inputStream = this.asInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
            WMIOUtils.closeSilently(outputStream);
        }
    }

    @Override
    public void copyTo(Writer writer) {
        Reader reader = null;
        try {
            reader = this.asReader();
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(reader);
            WMIOUtils.closeSilently(writer);
        }
    }

    @Override
    public Writer asWriter() {
        return this.asWriter(false);
    }

    @Override
    public Writer asWriter(boolean append) {
        return new OutputStreamWriter(this.asOutputStream(append), StandardCharsets.UTF_8);
    }

    @Override
    public void write(File file) {
        this.write(file.getContent().asInputStream());
    }

    @Override
    public void write(InputStream inputStream) {
        OutputStream outputStream = null;
        try {
            outputStream = this.asOutputStream();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
            WMIOUtils.closeSilently(outputStream);
        }
    }

    @Override
    public void write(Reader reader) {
        Writer writer = null;
        try {
            writer = this.asWriter();
            IOUtils.copyLarge((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(reader);
            WMIOUtils.closeSilently(writer);
        }
    }

    @Override
    public void write(String string) {
        Writer writer = null;
        try {
            writer = this.asWriter();
            IOUtils.write((String)string, (Writer)writer);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(writer);
        }
    }
}

