/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.FilteredResources;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceFilter;
import com.wavemaker.commons.io.ResourceFilterContext;
import com.wavemaker.commons.io.ResourceOperation;
import com.wavemaker.commons.io.Resources;
import com.wavemaker.commons.io.ResourcesCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public abstract class AbstractResources<T extends Resource>
implements Resources<T> {
    private final ResourceFilterContext resourceFilterContext = new ResourceFilterContext(){

        @Override
        public Folder getSource() {
            return AbstractResources.this.getSource();
        }
    };

    protected final ResourceFilterContext getResourceFilterContext() {
        return this.resourceFilterContext;
    }

    @Override
    public Resources<File> files() {
        return this.include(new ResourceFilter(){

            @Override
            public boolean match(ResourceFilterContext context, Resource resource) {
                return resource instanceof File;
            }
        });
    }

    @Override
    public Resources<Folder> folders() {
        return this.include(new ResourceFilter(){

            @Override
            public boolean match(ResourceFilterContext context, Resource resource) {
                return resource instanceof Folder;
            }
        });
    }

    @Override
    public Resources<T> include(ResourceFilter ... filters) {
        return FilteredResources.include(this, filters);
    }

    @Override
    public Resources<T> exclude(ResourceFilter ... filters) {
        return FilteredResources.exclude(this, filters);
    }

    @Override
    public void delete() {
        List<T> delete = this.fetchAll();
        for (Resource resource : delete) {
            resource.delete();
        }
    }

    @Override
    public Resources<T> moveTo(Folder folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be null");
        ArrayList<Resource> movedResources = new ArrayList<Resource>();
        for (Resource resource : this) {
            movedResources.add(resource.moveTo(this.calculateDestination(resource, folder)));
        }
        return new ResourcesCollection(folder, movedResources);
    }

    @Override
    public Resources<T> copyTo(Folder folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be null");
        ArrayList<Resource> copiedResources = new ArrayList<Resource>();
        for (Resource resource : this) {
            copiedResources.add(resource.copyTo(this.calculateDestination(resource, folder)));
        }
        return new ResourcesCollection(folder, copiedResources);
    }

    private Folder calculateDestination(T resource, Folder folder) {
        Folder parent = resource.getParent();
        if (parent == null) {
            return folder;
        }
        String name = parent.toStringRelativeTo(this.getSource());
        return name.length() == 0 ? folder : folder.getFolder(name);
    }

    @Override
    public <OPERATION extends ResourceOperation<T>> OPERATION performOperation(OPERATION operation) {
        for (Resource resource : this) {
            operation.perform((Resource)resource);
        }
        return operation;
    }

    @Override
    public List<T> fetchAll() {
        ArrayList<Resource> all = new ArrayList<Resource>();
        for (Resource resource : this) {
            all.add(resource);
        }
        return Collections.unmodifiableList(all);
    }
}

